C       FIBONACCI SEARCH TECHNIQUE FOR THE CONSTRAINED CASE
C
C	THIS PROGRAM IS USED TO FORECAST TARGET YEAR POPULATION.
C       IT USES A FIBONACCI SEARCH AS AN ENDOGENOUS CALIBRATION
C       TECHNIQUE FOR PARAMETERS B AND C.
C
C       MODIFIED TO USE A PART OF THE BASIC LINEAR ALGEBRA SUBROUTINE DGEMM
C       (Double precision, General, Matrix Multiply)
C       MODIFIED FOR THE MICROSOFT FORTRAN COMPILER FOR DOS
C       LAST MODIFIED 8/20/96
C
C	VARIABLE DECLARATIONS
C	DESCRIPTIONS OF THESE VARIABLES MAY BE FOUND AT THE END
C       OF THE DATA FILES LMBI4.DAT AND LMBI42.DAT.
C       SERI IS THE SUM OF THE INFINITE SERIES IN THE EQUATIONS:
C         E=BE*[I+FA+(FA)**2+...(FA)**M], M->INFINITY
C         N=BE*[I+FA+(FA)**2+...(FA)**M]*F, M->INFINITY
C
        INTEGER DD(42),DIM,AD,MRT,TUOUT,PRT
        REAL*8 CALINR(42,42),FOREINR(42,42)
        REAL*8 BASEP(42),BASEE(42),CALP(42),CALE(42),BASER(42)
        REAL*8 BB(42,42),AA(42,42),POP(42),CALR(42)
        REAL*8 SA(42,42),SF(42,42),CALH(42,42),CALG(42,42)
        REAL*8 D(42,42),F(42,42),A(42,42),P(42,42),SERI(42,42)
        REAL*8 UNIT(42,42),BE(42),RN(42),DINT(42),DINU(42),MAXPT
        REAL*8 E(42),RE(42),DINTT(42),DINUU(42),SROW(42),FORENC(42)
        REAL*8 BASESE(42),CALSE(42),BASEDW(42),BASECAR(42),BASETIN(42)
        REAL*8 AH(42),BASEN(42),BASEBE(42),DENO(42),BASERE(42)
        REAL*8 CALAU(42),CALTOL(42),CALAB(42),FOREBE(42),LAND(42)
        REAL*8 CT1(42,42),BT1(42,42),MAXP(42),THR(42),DIFB(5)
        REAL*8 DIFC(5),B(42),C(42),BT2(42,42),CT2(42,42),FA(42)
        REAL*8 BLOW(42,42),BHIG(42,42),CLOW(42,42),CHIG(42,42)
        REAL*8 BRAN(42,42),CRAN(42,42),B1(42,42),B2(42,42)
        REAL*8 C1(42,42),C2(42,42),CRIB(42,42),CRIC(42,42)
        REAL*8 FOREH(42,42),FOREG(42,42),TMP1(42),TMP2(42),POPT,ET
        REAL*8 BASET(42,42),BASEU(42,42),CALT(42,42),CALU(42,42)
        CHARACTER*20 FILENA
C
C NOTE: THE VARIABLE AD REPRESENTS THE MAXIMUM DATA SET ARRAY DIMENSION
C AVAILABLE FOR THIS COMPILATION.  IT SHOULD BE SET TO THE SAME VALUE
C THAT IS IN PARENTHESES IN ALL OF THE REAL*8 DECLARATIONS.
C THE VALUE OF AD MUST BE SET
C AT COMPILE TIME.  TO RUN THE PROGRAM WITH A DATA SET LARGER THAN THE
C CURRENT VALUE OF AD YOU MUST RECOMPILE WITH THE NEW VALUE OF AD SET
C AND UPDATED DECLARATIONS. WARNING!: AS AD GROWS LARGER THE PROGRAM 
C WILL USE EXPONENTIALLY MORE MEMORY AND RUN SLOWER.
        AD=42
C
C
C       GET INPUT FILE NAME
        WRITE (*,'(A)')' ENTER THE NAME OF THE INPUT FILE: '
        READ (*,'(A)') FILENA
        OPEN (2, FILE = FILENA, STATUS = 'OLD')
C
C       GET OUTPUT FILE NAME
        WRITE (*,'(A)')' ENTER THE NAME OF THE OUTPUT FILE: '
        READ (*,'(A)') FILENA
        OPEN (3, FILE = FILENA, STATUS = 'UNKNOWN')
C
        READ (2,*) DIM
        READ (2,*) ((CALH(I,J),CALG(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) ((CALINR(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) (BASEP(I),BASEE(I),CALP(I),CALE(I),I=1,DIM)
        READ (2,*) (BASER(I),CALR(I),BASESE(I),CALSE(I),I=1,DIM)
        READ (2,*) (BASEN(I),BASEBE(I),BASEE(I),I=1,DIM)
        READ (2,*) (SF(I,I),SA(I,I),I=1,DIM)
        READ (2,*) ((FOREINR(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) (FOREBE(I),I=1,DIM)
        READ (2,*) (FORENC(I),I=1,DIM)
        READ (2,*) MRT
        READ (2,*) TUOUT
        READ (2,*) PRT
        READ (2,*) ((FOREH(I,J),FOREG(I,J),J=1,DIM),I=1,DIM)
C
C
C	INITIALIZATION SECTION
C
        ITER=1
        ID=0
        ROAD=0.
        CALI=0.
C CALCULATE UNIT WHICH IS A UNIT MATRIX, SOME OTHER INITIALIZATION
        DO 15 I=1,DIM
           RE(I)=CALR(I)+CALSE(I)
           RN(I)=CALP(I)
           E(I)=CALE(I)
           BE(I)=FOREBE(I)
           DO 15 J=1,DIM
             UNIT(I,J)=0
             UNIT(I,I)=1
             CALT(I,J)=CALH(I,J)
             CALU(I,J)=CALG(I,J)
15      CONTINUE
C
C       MAIN LOOP BEGINS HERE
C
C CALCULATE CALIBRATION YEAR T AND U
18      DO 20 I=1,DIM
           DINT(I)=0.
           DINU(I)=0.
           DO 20 J=1,DIM
           IF (CALH(I,J).LT.0.)  CALH(I,J)=0.
           IF (CALG(I,J).LT.0.)  CALG(I,J)=0.
              DINT(I)=DINT(I)+RN(J)*CALH(I,J)
              DINU(I)=DINU(I)+RE(J)*CALG(I,J)
20      CONTINUE
        DO 22 I=1,DIM
           DO 22 J=1,DIM
           CALT(I,J)=RN(J)*CALH(I,J)/DINT(I)
           CALU(I,J)=RE(J)*CALG(I,J)/DINU(I)
22      CONTINUE
C
C IF THE PRT FLAG IS SET, CALCULATE BASE YEAR T AND U FROM THE
C   "25 MPH PRT" TRAVEL TIME MATRIX, OTHERWISE USE THE REGULAR
C   "DO-NOTHING" TRAVEL TIME MATRIX.
        IF (PRT .EQ. 1) GO TO 9000
C
C "DO-NOTHING" BASE YEAR T AND U
25      DO 27 I=1,DIM
           DINT(I)=0.
           DINU(I)=0.
           DO 27 J=1,DIM
           IF (CALH(I,J).LT.0.)  CALH(I,J)=0.
           IF (CALG(I,J).LT.0.)  CALG(I,J)=0.
              DINT(I)=DINT(I)+BASEP(J)*CALH(I,J)
              DINU(I)=DINU(I)+(BASER(J)+BASESE(J))*CALG(I,J)
27      CONTINUE
        DO 30 I=1,DIM
           DO 30 J=1,DIM
           BASET(I,J)=BASEP(J)*CALH(I,J)/DINT(I)
           BASEU(I,J)=(BASER(J)+BASESE(J))*CALG(I,J)/DINU(I)
30      CONTINUE
        GO TO 31
C
C "25 MPH PRT" BASE YEAR T AND U
9000    DO 9100 I=1,DIM
           DINT(I)=0.
           DINU(I)=0.
           DO 9100 J=1,DIM
           IF (FOREH(I,J).LT.0.)  FOREH(I,J)=0.
           IF (FOREG(I,J).LT.0.)  FOREG(I,J)=0.
              DINT(I)=DINT(I)+BASEP(J)*FOREH(I,J)
              DINU(I)=DINU(I)+(BASER(J)+BASESE(J))*FOREG(I,J)
9100    CONTINUE
        DO 9200 I=1,DIM
           DO 9200 J=1,DIM
           BASET(I,J)=BASEP(J)*FOREH(I,J)/DINT(I)
           BASEU(I,J)=(BASER(J)+BASESE(J))*FOREG(I,J)/DINU(I)
9200    CONTINUE
C
C BEGIN CALCULATE SMALL A AND SMALL F
31      CALL DGEMM (1,DIM,DIM,1.0D+0,BASEP,1,BASEU,AD,0.0D+0,TMP1,1)
        CALL DGEMM (1,DIM,DIM,1.0D+0,BASEE,1,BASET,AD,0.0D+0,TMP2,1)
        DO 34 I=1,DIM
           DO 34 J=1,DIM
           IF ( J .NE. I) GO TO 33
           IF (TMP1(J) .EQ. 0.0) GO TO 8000
           SA(I,I)=(BASER(J)+BASESE(J))/TMP1(J)
           GO TO 8010
8000       SA(I,I)=0.
8010       IF (TMP2(J) .EQ. 0.0) GO TO 8020
           SF(I,I)=BASEP(J)/TMP2(J)
           GO TO 8030
8020       SF(I,I)=0.
8030       FA(I)=SF(I,I)*SA(I,I)
              GO TO 34
33            SA(I,J)=0.
              SF(I,J)=0.
34     CONTINUE
C OUTPUT SMALL F, SMALL A, AND SF*SA AT TOP OF OUTPUT FILE
           WRITE(3,108)
              WRITE(3,*)
              WRITE(3,*)
           DO 35 I=1,DIM
35            WRITE(3,109) I,SF(I,I),SA(I,I),FA(I)
C END CALCULATE SMALL A AND SMALL F
C
C EXECUTE THIS SECTION OF CODE ONCE AT THE BEGINNING
        IF (ROAD .NE. 0.) GO TO 37
C SAVE INITIAL VALUES OF T AND U IN AA AND AB
         DO 36 I=1,DIM
           DO 36 J=1,DIM
              AA(I,J)=CALT(I,J)
36            BB(I,J)=CALU(I,J)
37         ROAD=1.
C
           WRITE (3,*)
C CALCULATE F=CALT*SF, A=CALU*SA, AND D=F*A
38      CALL DGEMM (DIM,DIM,DIM,1.0D+0,CALT,AD,SF,AD,0.0D+0,F,AD)
        CALL DGEMM (DIM,DIM,DIM,1.0D+0,CALU,AD,SA,AD,0.0D+0,A,AD)
        CALL DGEMM (DIM,DIM,DIM,1.0D+0,F,AD,A,AD,0.0D+0,D,AD)
C CALCULATE SERI=UNIT+D
        CALL ADD (UNIT,D,SERI,DIM,DIM,DIM)
C SET P=D.  P WILL BE ACCUMULATED AND USED TO CALCULATE EACH
C   SUCCESSIVE TERM OF THE INFINITE SERIES
        DO 40 I=1,DIM
           DO 40 J=1,DIM
           P(I,J)=D(I,J)
40      CONTINUE
C
C
         DO 60 I=1,1000000000
C CALCULATE P=D*P.  THIS CALCULATES THE TERMS OF THE INFINITE SERIES.
C ESSENTIALLY, THIS IS P=(FA)**(I+1)
            CALL DGEMM (DIM,DIM,DIM,1.0D+0,P,AD,D,AD,0.0D+0,P,AD)
                  IF (I .EQ. 1) GO TO 61
45          DO 50 II=1,DIM
               DO 50 JJ=1,DIM
C IF ONE ELEMENT OF THE INFINITE SERIES CONVERGES TO INFINITY, QUIT
               IF (P(II,JJ) .GT. 10.) GO TO 64
C IF ONE ELEMENT OF THE INFINITE SERIES TERM IS ABOVE A THRESHOLD VALUE,
C   CALCULATE ANOTHER TERM OF THE INFINITE SERIES
               IF (P(II,JJ) .GT. 0.000001) GO TO 55
50          CONTINUE
C IF THE TERMS OF THE INFINITE SERIES DROP BELOW A THRESHOLD VALUE,
C   BREAK OUT OF THE LOOP AND CALCULATE E AND N
            GO TO 65
55          LOOP=I+1
C IF THE SERIES IS DIVERGENT, QUIT
58          IF (LOOP .LT. 100) GO TO 60
59          WRITE(3,115) ITER,LOOP
            GO TO 4087
C ADD EACH TERM ONTO THE PREVIOUS SUM OF THE INFINITE SERIES,
C   THEN RETURN AND CALCULATE THE NEXT TERM
60        CALL ADD (SERI,P,SERI,DIM,DIM,DIM)
C
C THE FIRST TIME THROUGH THE LOOP CALCULATE THE ROW SUMS OF THE D=FA
C   MATRIX AND PRINT THEM OUT
61        DO 63 I=1,DIM
          SROW(I)=0.
            DO 62 J=1,DIM
            SROW(I)=SROW(I)+D(I,J)
62          CONTINUE
63        WRITE(3,89) I,SROW(I),ITER
            GO TO 45
C
C IF THE SERIES BLEW UP, PRINT AN ERROR MESSAGE AND QUIT
64        WRITE (3,260) II,JJ,P(II,JJ)
          GO TO 4087
C
C CALCULATE THE EMPLOYMENT AND POPULATION VECTORS
65      DO 66 I=1,3
66      CONTINUE
        DO 70 J=1,DIM
             E(J)=0.
             DO 70 I=1,DIM
             E(J)=E(J)+BE(I)*SERI(I,J)
70        CONTINUE
          DO 80 J=1,DIM
             POP(J)=0.
             DO 80 I=1,DIM
             POP(J)=POP(J)+E(I)*F(I,J)
80        CONTINUE
        WRITE(3,*)
        POPT=0.0
        ET=0.0
        MAXPT=0.0
        DO 81 I=1,DIM
          ET=ET+E(I)
          POPT=POPT+POP(I)
          MAXPT=MAXPT+FORENC(I)
81      CONTINUE
        WRITE(3,270) ET,POPT,MAXPT
        WRITE(3,*)
          DO 900 I=1,DIM
             THR(I)=E(I)-BE(I)
C IF THE LEVEL OF RETAIL ACTIVITY IS BELOW THE MINIMUM RETAIL
C   THRESHOLD, SET IT TO 0
             IF (THR(I) .GE. MRT) GO TO 900
             THR(I)=0.
900         RE(I)=THR(I)
            K=0
C
C DETERMINE WHICH ZONES EXCEED THE ZONING CONSTRAINT AND SET
C   THOSE POPULATIONS TO THE ZONING CONSTRAINT
          WRITE(3,*)
          DO 1000 I=1,DIM
             WRITE(3,100) I,POP(I),CALP(I),FORENC(I)
             IF (FORENC(I) .GE. 0.) GO TO 950
             WRITE(3,118)
             GO TO 4087
950       IF (POP(I) .LE. FORENC(I)) GO TO 1000
          POP(I)=FORENC(I)
          ID=ID+1
          K=K+1
          DD(K)=I
1000      RN(I)=POP(I)
C IF NO ZONES ARE REDISTRIBUTED THEN QUIT
          IF (ID .EQ. 0) GO TO 2500
C OUTPUT HOW MANY ZONES WERE REDISTRIBUTED AND WHICH ZONES
          WRITE (3,*)
          WRITE (3,110) ID
          WRITE (3,*)
          DO 1010 I=1,K
1010         WRITE (3,112) DD(I)
          WRITE (3,*)
          WRITE (3,*)
C
C DO THE FIBONACCI SEARCH
          DO 1020 I=1,DIM
             DO 1020 J=1,DIM
                BLOW(I,J)=0.
                CLOW(I,J)=0.
                BHIG(I,J)=4.
                CHIG(I,J)=4.
                BRAN(I,J)=BHIG(I,J)-BLOW(I,J)
                CRAN(I,J)=CHIG(I,J)-CLOW(I,J)
1020       CONTINUE
          DIVI=0.025
1045      B(1)=DIVI
          B(2)=2*DIVI
          C(1)=DIVI
          C(2)=2*DIVI
          DO 1055 I=1,DIM
             DO 1055 J=1,DIM
                K=2
1050            K=K+1
                B(K)=B(K-1)+B(K-2)
                IF (BRAN(I,J) .LE. 0.055) GO TO 1055
                IF (B(K) .GE. BRAN(I,J)) GO TO 1053
                   GO TO 1050
1053            B1(I,J)=BLOW(I,J)+B(K-1)
                B2(I,J)=BLOW(I,J)+B(K-2)
                CRIB(I,J)=(B1(I,J)+B2(I,J))/2.
1055        CONTINUE
            DO 1090 I=1,DIM
               DO 1090 J=1,DIM
                K=2
1060            K=K+1
                C(K)=C(K-1)+C(K-2)
                IF (CRAN(I,J) .LE. 0.055) GO TO 1090
                IF (C(K) .GE. CRAN(I,J)) GO TO 1080
                   GO TO 1060
1080            C1(I,J)=CLOW(I,J)+C(K-1)
                C2(I,J)=CLOW(I,J)+C(K-2)
                CRIC(I,J)=(C1(I,J)+C2(I,J))/2.
1090       CONTINUE
           DO 2000 II=1,DIM
              DO 2000 JJ=1,DIM
                 K=1
           DINT(II)=0.
           DINU(II)=0.
           DINTT(II)=0.
           DINUU(II)=0.
        IF(BRAN(II,JJ) .LE. 0.055 .AND. CRAN(II,JJ) .LE. 0.055)GOTO 2000
        IF (BRAN(II,JJ) .LE. 0.055) GO TO 1160
           DO 1150 J=1,DIM
              IF (CALH(II,J) .EQ. 0) GO TO 1150
              BT1(II,J)=CALH(II,J)**(-B1(II,JJ))
              BT2(II,J)=CALH(II,J)**(-B2(II,JJ))
              DINT(II)=DINT(II)+RN(J)*BT1(II,J)
              DINTT(II)=DINTT(II)+RN(J)*BT2(II,J)
1150          CONTINUE
1155          CALT(II,JJ)=RN(JJ)*BT1(II,JJ)/DINT(II)
              DIFB(K)=(AA(II,JJ)-CALT(II,JJ))**2
                 IF (K .EQ. 2) GO TO 1160
                 BT1(II,JJ)=BT2(II,JJ)
                 DINT(II)=DINTT(II)
                 K=K+1
                 GO TO 1155
1160              IF (CRAN(II,JJ) .LE. 0.055) GO TO 1550
                    K=1
                    DO 1170 J=1,DIM
                       IF (CALG(II,J) .EQ. 0) GO TO 1170
                       CT1(II,J)=CALG(II,J)**(-C1(II,JJ))
                       CT2(II,J)=CALG(II,J)**(-C2(II,JJ))
                       DINU(II)=DINU(II)+RE(J)*CT1(II,J)
                       DINUU(II)=DINUU(II)+RE(J)*CT2(II,J)
1170                   CONTINUE
1175                   CALU(II,JJ)=RE(JJ)*CT1(II,JJ)/DINU(II)
                       DIFC(K)=(BB(II,JJ)-CALU(II,JJ))**2
                       IF (K .EQ. 2) GO TO 1550
                       CT1(II,JJ)=CT2(II,JJ)
                       DINU(II)=DINUU(II)
                       K=K+1
                       GO TO 1175
1550        IF (BRAN(II,JJ) .LE. 0.055) GO TO 1570
            IF (DIFB(2) .LE. DIFB(1)) GO TO 1560
            BLOW(II,JJ)=B2(II,JJ)+DIVI
                 GO TO 1570
1560        BHIG(II,JJ)=B1(II,JJ)-DIVI
1570        IF (CRAN(II,JJ) .LE. 0.055) GO TO 1600
            IF (DIFC(2) .LE. DIFC(1)) GO TO 1590
            CLOW(II,JJ)=C2(II,JJ)+DIVI
                 GO TO 1600
1590        CHIG(II,JJ)=C1(II,JJ)-DIVI
1600        BRAN(II,JJ)=BHIG(II,JJ)-BLOW(II,JJ)
            CRAN(II,JJ)=CHIG(II,JJ)-CLOW(II,JJ)
            IF (BRAN(II,JJ) .LT. 0.) BRAN(II,JJ)=0.
            IF (CRAN(II,JJ) .LT. 0.) CRAN(II,JJ)=0.
2000        CONTINUE
          DO 2010 I=1,DIM
           DO 2010 J=1,DIM
           IF(BRAN(I,J) .LE. 0.055 .AND. CRAN(I,J) .LE. 0.055)GOTO 2010
           IF (CALI .GT. 1000.) GO TO 2050
           CALI=CALI+1.
                 GO TO 1045
2010       CONTINUE
C	CALCULATE B AND C
               SUMB=0.
               SUMC=0.
               DO 2030 I=1,DIM
                  DO 2030 J=1,DIM
                     SUMB=SUMB+CRIB(I,J)
2030                 SUMC=SUMC+CRIC(I,J)
               SUMB=SUMB/(DIM**2)
               SUMC=SUMC/(DIM**2)
               WRITE (3,*)
               WRITE(3,200) SUMB, ITER
               WRITE(3,*)
               WRITE(3,250) SUMC, ITER
               WRITE(3,*)
2035           DO 2040 I=1,DIM
                  DO 2040 J=1,DIM
                    IF (CALH(I,J) .EQ. 0) GO TO 2037
                    CALH(I,J)=CALH(I,J)**(-SUMB)
                    GO TO 2038
2037                CALH(I,J)=0.0
2038                IF (CALG(I,J) .EQ. 0) GO TO 2039
                    CALG(I,J)=CALG(I,J)**(-SUMC)
                    GO TO 2040
2039                CALG(I,J)=0.0
2040           CONTINUE
               DO 2044 I=1,DIM
                  DO 2044 J=1,DIM
                    IF (FOREH(I,J) .EQ. 0) GO TO 2041
                    FOREH(I,J)=FOREH(I,J)**(-SUMB)
                    GO TO 2042
2041                FOREH(I,J)=0.0
2042                IF (FOREG(I,J) .EQ. 0) GO TO 2043
                    FOREG(I,J)=FOREG(I,J)**(-SUMC)
                    GO TO 2044
2043                FOREG(I,J)=0.0
2044           CONTINUE
C       IF THE PROGRAM HAS ITERATED 9 TIMES WITHOUT A SOLUTION IT WILL QUIT.
C	CHANGE THE 9 BELOW TO A HIGHER NUMBER TO ALLOW MORE ITERATIONS.
2045       ID=0
           ITER=ITER+1
           IF (ITER .LT. 9) GO TO 2100
2050          WRITE (3,92) ITER,CALI
              GO TO 4087
2100       CALI=0.
C	RETURN TO THE BEGINNING
           GO TO 18
2500        WRITE(3,*)
            DO 3000 I=1,DIM
3000           WRITE(3,95) I,E(I),CALE(I)
            DO 3050 I=1,3
3050           WRITE(3,*)
            DO 3200 I=1,DIM
3200            WRITE(3,100) I,POP(I),CALP(I),FORENC(I)
                WRITE(3,*)
                WRITE(3,*)
         WRITE(3,105) ITER,ID
         WRITE (3,*)
         WRITE(3,200) SUMB, ITER
         WRITE(3,*)
         WRITE(3,250) SUMC, ITER
         WRITE(3,*)
4087        STOP
89       FORMAT (8X,'FOR ROW ',I2,' THE ROW SUM = ',F5.2,
     1         '  AT ITER.',I4)
90       FORMAT (5X,22I3/5X,20I3)
92       FORMAT (10X, ' INFINITE ITER. OR CALIBRATION AT ITER.',
     1     I3,' CALI. ',F6.0)
95       FORMAT ('EMPLOYMENT OF ZONE',I4,' =',F8.0,
     1      '  BASE YEAR DATA IS',F8.0)
100      FORMAT ('POP. OF ZONE',I4,' =',F9.0,
     1      '  BASE YEAR =',F9.0,'  CONSTRAINT =',F9.0)
105      FORMAT (8X,'THE PROGRAM ENDS AT ITER',I3,' WITH ',I2,
     1           ' ZONES POP. REDIST. ')
107      FORMAT (5X, 'FOR AGGREGATION CASE WITH   F  =  ',
     1   F7.4,'  AND   A  =  ',F7.4)
108      FORMAT (11X,'EXOGENOUSLY CALI. MULTIPLIERS USED IN',
     1   ' THE PROGRAM')
109      FORMAT (8X,'FOR ZONE',I3,2X,'FJ = ',F7.3,2X,'AJ = ',F7.3,
     1           2X,'FA = ',F7.3)
110      FORMAT (15X,I3,' ZONES POP. REDIST. IN THIS ITER.')
112      FORMAT (15X,'ZONE ',I3,' POP. REDISTRIBUTED.')
115      FORMAT (10X,'INFINITE LOOPS AT ITER.  ',I3,' LOOP',I4)
118      FORMAT (10X,'NEGATIVE MAXP(I)')
200      FORMAT (7X,' FIBONACCI SEARCH--FOR T(IJ). ',
     1   'THE MEDIAN OF B = -',F5.2,' AT ITER.', I3)
250      FORMAT (7X,' FIBONACCI SEARCH--FOR U(IJ). ',
     1   'THE MEDIAN OF C = -',F5.2,' AT ITER.',I3)
260      FORMAT ('INFINITE SERIES BLOWS UP AT INDICES ',I3,',',I3,
     1  ', VALUE = ',F7.3)
270      FORMAT ('EMPLOYMENT = ',F9.0,' POPULATION = ',F9.0,
     1   ' CONSTRAINT = ',F9.0)
         END
C                                                                  
C
         SUBROUTINE ADD (H,W,G,M,N,L)
         REAL*8 H(42,42),W(42,42),G(42,42)
         DO 110 I=1,N
            DO 110 J=1,M
            G(I,J)=H(I,J)+W(I,J)
110      CONTINUE
         RETURN
         END
C
        SUBROUTINE DGEMM (M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
        INTEGER            M, N, K, LDA, LDB, LDC
        DOUBLE PRECISION   ALPHA, BETA
        DOUBLE PRECISION   A( LDA, * ), B( LDB, * ), C( LDC, * )
        INTRINSIC          MAX
        INTEGER            I, J, L
        DOUBLE PRECISION   TEMP
        DOUBLE PRECISION   ONE         , ZERO
        PARAMETER        ( ONE = 1.0D+0, ZERO = 0.0D+0 )
C           Form  C := alpha*A*B + beta*C.
C
        DO 13090, J = 1, N
          IF( BETA.EQ.ZERO )THEN
          DO 13050, I = 1, M
            C( I, J ) = ZERO
13050     CONTINUE
          ELSE IF( BETA.NE.ONE )THEN
          DO 13060, I = 1, M
            C( I, J ) = BETA*C( I, J )
13060     CONTINUE
          END IF
          DO 13080, L = 1, K
            IF( B( L, J ).NE.ZERO )THEN
            TEMP = ALPHA*B( L, J )
            DO 13070, I = 1, M
              C( I, J ) = C( I, J ) + TEMP*A( I, L )
13070       CONTINUE
            END IF
13080     CONTINUE
13090   CONTINUE
C
        RETURN
C
C     End of DGEMM .
C
        END
