COMMENT Before running this code make sure that the data set
threeclusters123.sav is open in the same directory as this code.

COMMENT: This syntax is copyright by Robert B. Smith,  2011. 

COMMENT:  This code eliminates two of the three identical datasets.
USE ALL.
COMPUTE filter_$=(fileid=1).
VARIABLE LABEL filter_$ 'fileid=1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

COMMENT: This code focuses on the interaction
of the character and environmental variables on vote,
differences in environmental concern affect the relationship
between character and vote.
CROSSTABS
  /TABLES=choice3  BY charnvip  BY envirvip
  /FORMAT= AVALUE TABLES
  /STATISTIC=CHISQ LAMBDA CORR GAMMA D BTAU
  /CELLS= COUNT
  /COUNT ROUND CELL .

COMMENT: This code focuses on the interaction of the environmental
and character issues on vote, differences in the importance of a 
candidates character affects the relationship be the environmental issue
and vote.
CROSSTABS
  /TABLES=choice3  BY envirvip  BY charnvip
  /FORMAT= AVALUE TABLES
  /STATISTIC=CHISQ LAMBDA CORR GAMMA D BTAU
  /CELLS= COUNT
  /COUNT ROUND CELL .
