
COMMENT: Make sure the SPSS dataset ThreeClusters123.sav is open and in the same directory as this syntax.
COMMENT: This syntax is copyright by Robert B. Smith,  2011.

COMMENT This code selects only one of the three identical files.
USE ALL.
COMPUTE filter_$=(fileid=1).
VARIABLE LABEL filter_$ 'fileid=1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

COMMENT To view all of the output use Print Preview, 
zoom in to enlarge image, and use Next Page to cylce through the output.

COMMENT This code selects the best fitting model for the data.
HILOGLINEAR
 econreg1(2 4) hreformX(2 4) envirvip(1 2) charnvip(1 2) choice3(1 3) /METHOD=BACKWARD
 /CRITERIA MAXSTEPS(15) P(.05) ITERATION(20) DELTA(.5)
 /PRINT=FREQ RESID
 /DESIGN.

COMMENT This code selects the best fitting model, calculates the partial associations, and the estimates.
HILOGLINEAR
  econreg1(2 4) hreformx(2 4) envirvip(1 2) charnvip(1 2) choice3(1 3)  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(15) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .

COMMENT This code tests the parsimonious model.
HILOGLINEAR
  econreg1(2 4) hreformx(2 4) envirvip(1 2) charnvip(1 2) choice3(1 3)  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(15) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN  envirvip*charnvip*choice3 envirvip*econreg1*hreformx econreg1*choice3 hreformx*choice3.

COMMENT This code tests the synthesized model.
HILOGLINEAR
  econreg1(2 4) hreformx(2 4) envirvip(1 2) charnvip(1 2) choice3(1 3)  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(15) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM    
  /DESIGN envirvip*charnvip*choice3 envirvip*econreg1*hreformx econreg1*hreformx*choice3.