program Abcd

!date: 24 11 95     
!last modified 07 04 96
!bereken residu van A-B-C-D berekening
!f90 on 240696
!200799

use DFLIB
use my_rgb
use GraphParams
use InitiateCoch
use InitiateOae99

implicit NONE

logical*1  :: l_oldp
logical*1  :: l_noprobe, l_nostim
!real(4), dimension(8192) :: xx, yy
real(4)    ::  xlcm, ylcm, ydmp, h, hcm
real(8)    ::  tbuf
real(8), allocatable ::  pEC_local(:), p_residue(:)
integer(4) :: idum4, old_rgb_color
integer(4) :: n0, n1, n01
integer(4) :: i1, i1max, ilabel, j7 
integer(4) :: nn, mode
integer(4) :: npnt, ipnt
integer*2  :: idum2,  irow
character(len=5)  :: txtn
character(len=64) :: file_x
character(len=80), dimension(6) :: C
character(len=80), dimension(24):: txt
character(len=40), dimension(6) :: Ctext
character(len=10), parameter :: pearcan='pearcan.dt'
character(len=10), parameter :: param  ='newpar.dat'
character(len=10), parameter :: profile='profile.dt'
character(len=15) :: fname
character(len=13) :: fcnt='countfile.dat'
integer(4) :: ncountfile
record /rccoord/ rc

namelist /coch0/ nt_ME, dt, s_r_factor, s_x_factor, x_0
namelist /init/  l_init,l_store,l_screenplot,l_out, T_max
namelist /cochlea/ n,BM_impedance_factor,FREQUENCY_MAP
namelist /stimpars/ t0,StimulusPeriod,ProbePeriod,L_stim,L_probe		&
&		,probe_onset_duration,num_sec_tot,l_coupler
namelist /nonlinearity/ NonLin,alpha
namelist /nonlin2/ beta  
namelist /nonlin3/ gamma
namelist /nonlin4/ d_factor
namelist /countfile/ ncountfile


open (2,file='newpar.dat') !until 280596:params.dat
print*,'newpar.dat opened'
read(*,*)

read (2,coch0)
!print*,'coch0 read'
!read(*,*)
read (2,init)
!print*,'init read'
!read(*,*)
read (2,cochlea)
!print*,'cochlea read'
!read(*,*)
read (2,stimpars)
!print*,'stimpars read'
!read(*,*)
read (2,nonlinearity)
!print*,'nonlinearity read'
!read(*,*)
read (2,nonlin2)
read (2,nonlin3)
read (2,nonlin4)
close(2)
print*,'newpar.dat read'


open (3,file=fcnt)
read (3,countfile)
close(3)

write(fname,111)      &
	&   NonLin                                &
	&   ,idnint(L_stim/1.d1)				  &
    &   ,idnint(abs(L_probe)/1.d1)			  &
    &   ,num_sec_tot						  &
    &   ,idnint(probe_onset_duration*1.d3) 	  &
    &   ,idnint(BM_impedance_factor)		  &
	&   ,FREQUENCY_MAP						  &
	&   ,idnint(dt*2.d6)                      &   
    &   ,nint(n/100.)						  &
    &   ,idnint(0.010/StimulusPeriod) 				  &
	&   ,MOD(ncountfile,16)
111  format(Z1,Z1,Z1,Z1,Z1,Z1,Z1,Z1,Z1,I2.2'.dt',Z1)

print*,fname
read(*,*)
open (3,file='pearcan.dt') 
print*,'pearcan.dt read'
read(*,*)
open (4,file=fname)
print*,'fname '
read(*,*)
T_section   = StimulusPeriod*DBLE(INT(T_sect_default/StimulusPeriod)+0.5)
print*,'tsection', T_section
read(*,*)
npnt     =  NINT(T_section/dt) !*400000) !=T_section/dt!!!
print*,'npnt',npnt
read(*,*)
ncountfile=ncountfile+1

allocate (p_residue(npnt+10),pEC_local(npnt+10) )

!: +A
do ipnt=1,npnt
   read(3,*) tbuf,p_residue(ipnt)
enddo   

!: -B
do ipnt=1,npnt
   read(3,*) tbuf,pEC_local(ipnt)
   p_residue(ipnt)=p_residue(ipnt)-pEC_local(ipnt)
enddo   

!: -C
do ipnt=1,npnt
   read(3,*) tbuf,pEC_local(ipnt)
   p_residue(ipnt)=p_residue(ipnt)-pEC_local(ipnt)
enddo   

!: +D
do ipnt=1,npnt
   read(3,*) tbuf,pEC_local(ipnt)
   p_residue(ipnt)=p_residue(ipnt)+pEC_local(ipnt)
   write(4,*) ipnt*sngl(dt),sngl(p_residue(ipnt))
enddo   

close(3)

write (4,coch0)
write (4,init)
write (4,cochlea)

write (4,stimpars)
write (4,nonlinearity)
write (4,nonlin2)
write (4,nonlin3)
write (4,nonlin4)
close (4)

open (2,file=fcnt)
write(2,countfile)
close(2)

deallocate (p_residue,pEC_local )


end             
