! displays user set parameters in LEGEND_UNIT window

SUBROUTINE InitializeLegend (resampling)
	USE IFQWIN
	USE IFPORT
	USE Declare
	USE WaveReadModule
	USE WindowsModule

	IMPLICIT NONE
	LOGICAL, INTENT(IN) :: resampling
	CHARACTER(22) RealToString
	CHARACTER(12) IntToString
	CHARACTER(100) string
	CHARACTER(1) drive
	CHARACTER(1) dir
	CHARACTER(10) ext
	integer(4) :: setActiveQQresult
	integer(4) :: splitPathQQresult
	TYPE (rccoord) curpos,last_legend_pos
 
	IF (plotLegend) THEN
		IF (resampling) THEN
			setActiveQQresult = SETACTIVEQQ (LEGEND_UNIT)
			CALL CLEARSCREEN($GCLEARSCREEN)
			WRITE (LEGEND_UNIT, *) "  0 %"	! row 1
			WRITE (LEGEND_UNIT, *)					! row 2
			WRITE (LEGEND_UNIT, *) " Resampling audio signal"		!row 3
			WRITE (LEGEND_UNIT, *) " from ", TRIM(IntToString(SamplesPerSec)), " Hz to ", TRIM(RealToString(ComputationalFrequency/1000, 3)), " kHz"	! row 4
		ELSE
			setActiveQQresult = SETACTIVEQQ (LEGEND_UNIT)
			CALL CLEARSCREEN($GCLEARSCREEN)
			! use first line to indicate progess in percents
			! row 1 - 3:
			WRITE (LEGEND_UNIT, *) "  0 %"
			WRITE (LEGEND_UNIT, *) "sections: ", TRIM(IntToString(n))
			WRITE (LEGEND_UNIT, *) "total time: ", TRIM(RealToString(t_max * 1d3, 3)), " ms"
			! row 4:
			IF (parameterSet == HUMAN) THEN
				WRITE (LEGEND_UNIT, *) "Human cochlea"
			ELSE
				WRITE (LEGEND_UNIT, *) "Cochlea of guinea pig"
			ENDIF
			! row 5:
			IF (useGreenwoodMap) THEN
				WRITE (LEGEND_UNIT, *) "frequency map: Greenwood"
			ELSE
				WRITE (LEGEND_UNIT, *) "frequency map: exponential"
			ENDIF
			IF (useAudioFile) THEN
				splitPathQQresult = SPLITPATHQQ(AudioFileName, drive, dir, string, ext)
				! row 6 - 7
				WRITE (LEGEND_UNIT, *) "Stimulus: ", TRIM(string), TRIM(ext)
				WRITE (LEGEND_UNIT, *) "Level: ", TRIM(RealToString(AudioFileLevel, 2)), " dB SPL"
			ELSE
				string = "Stim:"
				IF (useSignal1) THEN 
				 string = TRIM(string) // " f1=" // TRIM(RealToString(signal1Frequency, 3)) // ";"
                 string = TRIM(string) // " phi1=" // TRIM(RealToString(signal1Phase, 3)) // " x pi;"
                END IF 
				IF (useSignal2) THEN
				 IF (useSignal1) THEN 
				    WRITE (LEGEND_UNIT, *) TRIM(string)
				    string = "and"
				 END IF
				 string = TRIM(string) // " f2=" // TRIM(RealToString(signal2Frequency, 3)) // ";"
                 string = TRIM(string) // " phi1=" // TRIM(RealToString(signal2Phase, 3)) // " x pi;"
                END IF 
				IF (useSignal3) THEN
				 string = TRIM(string) // "T=" // TRIM(RealToString(signal3Period, 3))
                END IF 
				! row 6
				WRITE (LEGEND_UNIT, *) TRIM(string) 
				string = "Level(s):"
				IF (useSignal1) THEN 
				  string = TRIM(string) // " L1= " // TRIM(RealToString(signal1Level, 3))
				  IF (useSignal2 .or. useSignal3) string = TRIM(string) // ","
				END IF
				IF (useSignal2) THEN 
				  string = TRIM(string) // " L2= " // TRIM(RealToString(signal2Level, 3))
				  IF (useSignal3) string = TRIM(string) // ","
				END IF  
				IF (useSignal3) string = TRIM(string) // " L3= " // TRIM(RealToString(signal3Level, 3))// ";"
				! row 7
				WRITE (LEGEND_UNIT, *) TRIM(string) // " dB SPL;" 
			ENDIF
			! row 8
			IF (useConstantQ) THEN
				WRITE (LEGEND_UNIT, *) "Q = ", TRIM(RealToString(ConstantQ, 3))
			ELSE
				WRITE (LEGEND_UNIT, *) "Q = const * SQRT(f)"
			ENDIF
	
			! row 9
			SELECT CASE (stiffness)
			CASE (LINEAR)
				WRITE (LEGEND_UNIT, *) "Linear stiffness"
			CASE (NONLINEAR)
				WRITE (LEGEND_UNIT, *) "Nonlinear stiffness"
			CASE (GOLDSTEIN)
				WRITE (LEGEND_UNIT, *) "Goldstein stiffness"
			CASE (ZWEIGLINEAR)
				WRITE (LEGEND_UNIT, *) "Linear Zweig impedance"
			CASE (ZWEIGNONLINEAR)
				WRITE (LEGEND_UNIT, *) "Nonlinear ZweigImpedance"
			ENDSELECT

			! possibly row 10
			SELECT CASE (damping)
			CASE (LINEAR)
				WRITE (LEGEND_UNIT, *) "Linear damping"
			CASE (NONLINVDP)
				WRITE (LEGEND_UNIT, *) "Van der Pol oscillator damping"
			CASE (RAYLEIGH)
				WRITE (LEGEND_UNIT, *) "Rayleigh-oscillator damping"
			CASE (HOPF)
				WRITE (LEGEND_UNIT, *) "Hopf-bifurcation damping (ampl)"
			CASE (HOPV)
				WRITE (LEGEND_UNIT, *) "Hopf-bifurcation damping (vel)"
			CASE (NONLINEAR)
				IF (useActiveDamping) THEN
					WRITE (LEGEND_UNIT, *) "Active nonlinear damping 00"
				ELSE
					WRITE (LEGEND_UNIT, *) "Nonlinear damping 00"
				ENDIF
			CASE (NONLIN006)
				IF (useActiveDamping) THEN
					WRITE (LEGEND_UNIT, *) "Active nonlinear damping 06"
				ELSE
					WRITE (LEGEND_UNIT, *) "Nonlinear damping 06"
				ENDIF
			CASE (NONLIN007)
				IF (useActiveDamping) THEN
					WRITE (LEGEND_UNIT, *) "Active nonlinear damping 07"
				ELSE
					WRITE (LEGEND_UNIT, *) "Nonlinear damping 07"
				ENDIF
			CASE (GOLDSTEIN)
				WRITE (LEGEND_UNIT, *) "Goldstein damping"
			ENDSELECT
	
			! possibly row 10-11 or 11-12
			IF (useApexShortCut) WRITE (LEGEND_UNIT, *) "Apex shortcut"
			IF (useEarCanalCoupler) WRITE (LEGEND_UNIT, '($A18)') " Ear canal coupler"

			CALL GETTEXTPOSITION (last_legend_pos)
			last_legend_row=last_legend_pos%row

			IF (plotPositions) THEN
				WRITE (MEMBRANE_UNIT, *) TRIM(RealToString(DBLE(maximumPositionToPlot * 1d9), 2)) // " nm"
				CALL SETTEXTPOSITION (INT2(upper_graphs_height), INT2(0), curpos)
				WRITE (MEMBRANE_UNIT, '($A9)') TRIM(RealToString(DBLE(minimumPositionToPlot * 1d9), 2)) // " nm"
			ELSE
				WRITE (MEMBRANE_UNIT, *) TRIM(RealToString(DBLE(maximumVelocityToPlot * 1d6), 2)) // " nm/ms"
				CALL SETTEXTPOSITION (INT2(upper_graphs_height), INT2(0), curpos)
				WRITE (MEMBRANE_UNIT, '($A12)') TRIM(RealToString(DBLE(minimumVelocityToPlot * 1d6), 2)) // " nm/ms"
			ENDIF

		ENDIF
	ENDIF
END SUBROUTINE InitializeLegend