! fills the window needed for the convolution while downsampling a factor <down>
! and sets windowBoundary. The larger the window the more precise is
! the downsampling and the longer it takes to compute it.

SUBROUTINE InitializeSampleDown(down)
	USE SampleDownModule
	IMPLICIT NONE

	REAL, PARAMETER :: alphaKB = 11 ! ( = 3.5 * pi )
	REAL relative_f_cutoff
	INTEGER, INTENT(IN) :: down
	REAL, ALLOCATABLE :: KB(:)
	INTEGER err

	windowBoundary = down * 5
	ALLOCATE (KB(-windowBoundary:windowBoundary), &
								window(-windowBoundary:windowBoundary), &
								STAT = err)
	IF (err /= 0) CALL AllocationError

	! f_cutoff is relative to the sample frequency of the upsampled signal
	! f_cutoff moet kleiner zijn van 1/(2*down)
	relative_f_cutoff = .4d0/REAL(down)
	CALL LowPassFilter (window, windowBoundary, relative_f_cutoff)
	CALL KaiserBessel (KB, windowBoundary, alphaKB)
	window = window * KB
	
	DEALLOCATE (KB)

END SUBROUTINE InitializeSampleDown