! returns RGB-color defined by <value> and scaled between <smallest> and <biggest>
! <biggest> must be bigger than <smallest>
! if <value> is smaller than <smallest>, <colormap> will be black
! if <value> is bigger than <biggest>, <colormap> will be white

FUNCTION colormap (value, smallest, biggest)

	USE DFLIB
	REAL, PARAMETER :: ColorsUsed=1020	! ColorsUsed = 128+255+255+255+127
	INTEGER colormap
	REAL, INTENT (IN) :: value, smallest, biggest
	REAL index
	INTEGER(2) colorIndex
	integer*4 :: red, green, blue

	index = ColorsUsed * (value-smallest)/(biggest-smallest)
	! prevent integer2-overflow by taking the range [-32768, 32767]
	colorIndex = ININT(MAX(-32768., MIN(32767., index)))
	SELECT CASE (ColorIndex)
	CASE (:-1)	!RGB = BLACK
		red = 0
		green = 0
		blue = 0
	CASE (0:127)	!RGB = 0, 0, 128-255
		red=0
		green=0
		blue=128+ColorIndex
	CASE (128:382)	!RGB = 0, 1-255, 255
		red=0
		green=ColorIndex-127
		blue=255
	CASE (383:637)	!RGB = 1-255, 255, 255-0
		red=ColorIndex-382
		green=255
		blue=637-ColorIndex
	CASE (638:892)	!RGB = 255, 254-0, 0
		red=255
		green=892-ColorIndex
		blue=0
	CASE (893:1020)	!RGB = 254-127, 0, 0
		red=1147-ColorIndex
		green=0
		blue=0
	CASE (1021:)	!RGB = WHITE
		red = 255
		green = 255
		blue = 255
	END SELECT

	colormap = RGBTOINTEGER (red, green, blue) 

END FUNCTION colormap