! returns the decibel-value of <level> relative to <reference>.
! for values lower than <minimum_value>, this <minimum_value> will be used

FUNCTION LevelToDecibel (level, reference)
	IMPLICIT NONE
	REAL(8) LevelToDecibel
	REAL(8), INTENT(IN) :: level
	REAL(8), INTENT(IN) :: reference
	REAL(8), PARAMETER :: minimum_level = 1d-100

	LevelToDecibel = 20 * DLOG10(MAX(level, minimum_level) / reference)

END FUNCTION