! Plots the displacement or the velocity (dependant on the value of <plotPositions>)
! in MEMBRANE_UNIT by setting pixels on the linear scale where values equal to
! <MaximumPositionToPlot> correspond to the upper pixels of MEMBRANE_UNIT
! and values equal to <MinimumPositionToPlot> correspond to the lower pixels of
! MEMBRANE_UNIT

SUBROUTINE PlotMembraneGraph

	USE Declare
	USE GraphsModule
	USE WindowsModule
	USE IFQWIN
	IMPLICIT NONE
	integer(4)    :: setActiveQQresults 
    CHARACTER(12) :: IntToString

	setActiveQQresults = SETACTIVEQQ (MEMBRANE_UNIT) 

	! clear old membrane line
	Call SETPIXELSRGB (n_plotpoints, section_axis, membrane_y_pixel, black)

	! determine on which pixels the membrane-velocity or -displacement shall be plotted
	IF (plotPositions) THEN
		membrane_y_pixel = (-(positionMatrix(section_axis, t_plotCounter) - minimumPositionToPlot) / (maximumPositionToPlot - minimumPositionToPlot) + 1) * (upper_graphs_height * 16 -1)
	ELSE
		membrane_y_pixel = (-(velocityMatrix(section_axis, t_plotCounter) - minimumVelocityToPlot) / (maximumVelocityToPlot - minimumVelocityToPlot) + 1) * (upper_graphs_height * 16 -1)
	ENDIF

	! plot the new membrane line
	Call SETPIXELSRGB (n_plotpoints, section_axis, membrane_y_pixel, white) 

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!Store Membrane Velocities for last 1/8th periods
!IF (kk>kmax-100) THEN
!OPEN (161, FILE = TRIM(OutputDirectory) // "Membraan(" // TRIM(IntToString(kmax-kk)) // ")" // TRIM(IntToString(INT(signal1Frequency))) // "Hz.dat", FORM = 'BINARY')
!DO i=0, n_plotpoints-1
!	WRITE (161) SNGL(velocityMatrix(i, t_plotCounter))
!ENDDO
!CLOSE (161)
!ENDIF
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


END SUBROUTINE PlotMembraneGraph
