	! Calculation of diagonal elements of tridiagonal matrix A.
	! This has to be done only once because A is time invariant.
SUBROUTINE InitializeGaussElimination

	USE Declare
	IMPLICIT NONE
	REAL(8) Scala_Area
	! Tridiagonal matrix has in the upper left corner the value AME,
	! in the lower right corner AHT and the diagonal values in between are ASC
	REAL(8) AME
	REAL(8) ASC
	REAL(8) AHT

	Scala_Area = scalaWidth(parameterSet) * scalaHeight(parameterSet)
	Asq = 2 * rho * bm_width / (bm_mass * Scala_Area) * dx ** 2

	AME = 1 + (gam0 * Asq)
	ASC = 2 + Asq
	AHT = 1 + Asq + DSQRT(Asq)

	!frequency independent matching impedance when Qn=0,5
	phi = 2 * rho * dx / Scala_Area * DSQRT(sdivm(n))	! sdivm is already the stiffness divided by the mass, so the m is removed from the formula
	Asq0 = gam0 * Asq
	IF (useApexShortcut) THEN
		AHT=ASC
		phi = 0
	ENDIF

	! Calculation of coefficients necessary to solve the tridiagonal system.
	! (First the tridiagonal matrix is transformed into a lower triangle
	! matrix.
	! Furthermore we use the fact that matrix A is represented by only
	! three different diagonal elements (AME,ASC and AHT) and all sub- 
	! and super diagonal elements are equal to -1.)

	b(n) = 1 / AHT
	DO i = n-1, 1, -1
		b(i) = 1 / (ASC - b(i+1))
	ENDDO
	b(0) = 1 / (AME - b(1) )

END SUBROUTINE
