! Calculation of values related to 'loudness' and frequency of an external stimulus.

SUBROUTINE InitializeStimulus
	USE Declare
	IMPLICIT NONE

	IF (useAudioFile) THEN
    	audioFilePressure = LevelToPressure (audioFileLevel, p0)
		maximumSignalPressure = audioFilePressure
	ELSE
    	signal1Pressure = LevelToPressure (signal1Level, p0)
	    signal2Pressure = LevelToPressure (signal2Level, p0)
	    signal3Pressure = LevelToPressure (signal3Level, p0)
	    signal1AngularFrequency = 2.d0 * pi * signal1Frequency
	    signal2AngularFrequency = 2.d0 * pi * signal2Frequency
		maximumSignalPressure = 0.d0
		IF (useSignal1)	maximumSignalPressure = signal1Pressure
		IF (useSignal2)	maximumSignalPressure = maximumSignalPressure + signal2Pressure
		IF (useSignal3)	maximumSignalPressure = maximumSignalPressure + signal3Pressure
	ENDIF

CONTAINS

REAL(8) FUNCTION LevelToPressure (dB_value, reference)
	IMPLICIT NONE
	REAL(8), INTENT(IN) :: dB_value
	REAL(8), INTENT(IN) :: reference

	LevelToPressure = reference * 10 ** (dB_value / 20.d0)

END FUNCTION

END SUBROUTINE InitializeStimulus