! m = bm_mass / area
! ddivm = damping / bm_mass
! sdivm = stiffness / bm_mass

SUBROUTINE SetDampingAndStiffness

	USE Declare
	IMPLICIT NONE
	REAL(8) f_resonance(0:n)
	REAL(8) omega(0:n)	! = 2 pi * f_resonance
	REAL(8) QualityFactor(0:n)

	! Determine frequencies for all sections using the selected frequency map
	IF (useGreenwoodMap) THEN
		f_resonance = f_base_Greenwood_map(parameterSet) * 10 ** (-kappa_Greenwood_map(parameterSet) * x) - apex_corr_Greenwood_map(parameterSet)
	ELSE
		f_resonance = f_base_exp_map(parameterSet) * 10 ** (-kappa_exp_map(parameterSet) * x)
	ENDIF
	omega = 2 * pi * f_resonance

	IF (useConstantQ) THEN
		QualityFactor = ConstantQ
		ddivm = omega / QualityFactor
	ELSE
		! Use a square root profile for Q
		! Make Q equal to 0.5 at the apex
		! in order to get an optimal, frequency independent,
		! matching impedance at that point. 
		! Q(i) = 0.5 + const * SQRT( f(i) - f(n) )
		! const is set so Q(i)>20 for f(i) > 4 kHz
! original version JK		QualityFactor = 0.5d0 + 0.3d0 * DSQRT(f_resonance - f_resonance(n)) 
! original HD       		QualityFactor = 0.5d0*DSQRT(f_resonance/f_resonance(n))
!		modified HD 21 aug 2005; do not use Q-factor as primary parameter
!  use omega and sdivm, then Q and ddivm
!! test 2009: reduce ddivm by factor 2
!		ddivm=1.d2*omega**(1.d0/3.d0) original  
		ddivm=1.d2*omega**(1.d0/3.d0) /2.d0 
        ddivmvdP=0.05*omega
	ENDIF

	! Definition of Quality factor ("Classical Dynamics of particles and systems" by M. Thornton, page 128):
	! Q = omega * mass / damping
	! ---> ddivm in program already scaled by mass --->
	!	ddivm = omega / QualityFactor

	! Angular resonance frequency for free oscillations with damping (same book, same page):
	! omega ^2 = stiffness/mass - 0.25 * (damping/mass)^2 = stiffness/mass - 0.25 * (omega / Q)^2
	! ---> sdivm in program already scaled by mass --->
	sdivm = omega ** 2 !! correction factor for asymmetric tuning removed 210805!! *(1 + 1/(2*QualityFactor **  2))

!!	sdivm = omega ** 2 * (1 + 1 / (4 * QualityFactor **  2))

END SUBROUTINE SetDampingAndStiffness