!This module is shared by "Cochlea" and "CochleaDialog"

! Module contains variables and constants for all values concerning the
! real cochlea and middle ear, including parameters for Zweig-impedance

MODULE CochleaParameters
	IMPLICIT NONE

	! For the two-dimensional parameters, varable: parameterSet 
	! parameterSet=1 (or: HUMAN) gives human values, parameterSet=2 (or: GUINEA_PIG) gives guinea pig values
    ! Note 1: that FORTRAN is (as a rule) NOT case sensitive, so the use
    ! of upper case and lower case characters is primarily for clarification.
    ! Note 2: the extension d# implies a double precision exponential factor (power 10)
	
	! cochlea parameters
	REAL(8), PARAMETER :: cochleaLength (2)     = [36d-3, 18.5d-3]  !m      **HUMAN set to 35 + 1mm for apex [Dec09]
	REAL(8), PARAMETER :: bmMass(2)             = [0.5d0, 0.25d0]	!kg/m2
	REAL(8), PARAMETER :: bmImpedanceFactor(2)	= [1d0, 0.75d0]     !dimensionless
	    !bmInpedanceFactor: scaling factor which enables overall parameter adjustments. Default: := 1
	REAL(8), PARAMETER :: scalaWidth(2)         = [1d-3, 0.5d-3]	!m
	REAL(8), PARAMETER :: scalaHeight(2)        = [1d-3, 0.5d-3]	!m
	REAL(8), PARAMETER :: helicotremaWidth(2)   = [1d-3, 0.5d-3]	!m  note: also used for helicotremalength
	REAL(8), PARAMETER :: rho                   = 1d3		        !kg/m3
	    !rho: average density of cochlear fluid, approx. equal to density of water
	REAL(8), PARAMETER :: Q_constant_default    = 20d0              !default Q-value for cochlear tuning curve, DIM 0 
	REAL(8) bm_mass	    ! kg/m2
	REAL(8) bm_width	! m
	REAL(8) bm_length	! m

	! Frequency map parameters, x measured from stapes
	! Exponential Map:  f(x) = f_base * 10 ^ (-kappa x)
	REAL(8), PARAMETER :: f_base_exp_map (2)    = [22507d0, 38346d0]	!Hz
	REAL(8), PARAMETER :: kappa_exp_map (2)     = [65.1d0, 113.5d0]	    !1/m

	! Greenwood Map:    f(x) = f_base * 10 ^ (-kappa x) - f_apex  *****was formulation before 2010
	!*************************************************************************************************Modified
	! The original formula is f = 165.4 ( 10 ^ (kappa x1) - k ) with some discussion about k, but kappa = 60 /m
	!   where x1 is measured from apex. Using x = 35 - x1, gives:
	!   f = 165.4 ( 10 ^ (60*(0.035-x))- k ) = 165.4 * ( 10 ^2.1 * 10 ^ (-kappa x) - k)
	!     = 165.4 * 10^2.1 ( 10 ^ (-kappa x) - k * 10^(-2.1) )
	!     = 165.4 * 10^2.1 ( 10 ^ (-kappa x)) - k * 165.4
	!   The apex value = 165.4 ( 10^0 - k) = 165.4 (1 - k) !!! => zero for k=1; 24.81 for k=0.85; and 33.08 for k=0.8 .
	!   value used originally by us is: k = 0.85
	!   Likewise, f_base= 165.4 (10^2.1 - k), => 20674 for k=0.9; 20682 for k=0.85; 20690 for k=0.8
	!   This has been the basis for the value: f_base_Greenwood_map.
	!   The value originally called f_apex was just k x 165.4! Formula is in principle OK, but term f_apex should be called apex_corr
	!   and values have to be adjusted to the correct values.  Effect correction appears marginal 
	!
	REAL(8), PARAMETER :: f_base_Greenwood_map(2)     = [20682d0,  43765d0]	!Hz
	REAL(8), PARAMETER :: kappa_Greenwood_map (2)     = [60d0,     113.5d0]	!1/m (=2.1/bmlength)
	REAL(8), PARAMETER :: apex_corr_Greenwood_map (2) = [140.59d0, 297.5d0]	!Hz not the proper term. It is 165.4 x k-term

	! Middle Ear parameters
	REAL(8), PARAMETER :: stapesArea(2)                 = [3d-6, 0.81d-6]   !m2
	REAL(8), PARAMETER :: EardrumArea(2)                = [60d-6, 23.9d-6]  !m2
	REAL(8), PARAMETER :: MiddleEarResonanceFrequency(2)= [2d3, 4d3]        !Hz
	REAL(8), PARAMETER :: MiddleEarQualityFactor        = 0.4d0             !dimensionless
	REAL(8), PARAMETER :: SpecificAcousticImpedanceOfAir = 415d0            !Ns/m3        = Pa/(m/s)
	REAL(8), PARAMETER :: middleEarTransformer(2)       = [30d0, 39.3d0]    !dimensionless
	REAL(8), PARAMETER :: damping_coupler(2)            = [140d5, 280d5]	!Ns/m5 =kg/sm4= Pa/(m3/s)
	REAL(8), PARAMETER :: mass_coupler(2)               = [43.4d2, 21.7d2]	!kg/m4
	REAL(8), PARAMETER :: stiffness_coupler             = 1d0/2.28d-11      !kg/s2m4

	REAL(8), PARAMETER :: p0    = 2d-5  !Pa = N/m2

	! Nonlinearity parameters
	REAL(8), PARAMETER :: NLparmAlpha = 1d5   !scaling factors (NLparmAlpha and NLparmBeta should be replaced) 
	REAL(8), PARAMETER :: NLparmBeta  = 1d6   !22/9.10: done for alpha, multiplied by 10

	! ZWEIG parameters
	REAL(8), PARAMETER :: zweigQ                = -8.217d0           
	REAL(8)            :: ZweigRho              = 0.1416d0  !here we use an initial value (not fixed parameter)
	REAL(8), PARAMETER :: ZweigFactor           = 1.742d0
	REAL(8), PARAMETER :: ZweigQAtBoundaries    = 20d0
	REAL(8), PARAMETER :: ZweigBeta             = 10000d0
	REAL(8), PARAMETER :: ZweigGamma            = 6200d0
    
END MODULE CochleaParameters