!This module is shared by "Cochlea" and "CochleaDialog"

! module contains variable names whose values are read from and written to parameters.dat

MODULE ParametersModule

! General parameters
INTEGER n		!Number of BM-sections
REAL(8) ComputationalFrequency
REAL(8) t_max
LOGICAL retrieveMembraneStatus							!read mebrane status or not
LOGICAL storeMembraneStatus						!write membrane status or not
CHARACTER(127) settingsDirectory

! Stimulus parameters
!REAL(8), PARAMETER :: PI=3.1415926535897932384626433832795028841971693993751
REAL(8) signal1Period
REAL(8) signal1Frequency
REAL(8) signal1Level
REAL(8) signal1Phase
LOGICAL useSignal1

REAL(8) signal2Period
REAL(8) signal2Frequency
REAL(8) signal2Level
REAl(8) signal2Phase
LOGICAL useSignal2

REAL(8) signal3Period
REAL(8) signal3Duration
REAL(8) signal3Level
LOGICAL useSignal3

REAL(8) signal1AngularFrequency
REAL(8) signal2AngularFrequency
REAL(8) signal1Pressure
REAL(8) signal2Pressure
REAL(8) signal3Pressure
REAL(8) p0x	!druk op x=0

REAL(8) OnsetDuration

LOGICAL useAudioFile
LOGICAL useLeftChannel		!use left or right channel from audio file
REAL(8) audioFileLevel
REAL(8) audioFilePressure
CHARACTER(127) audioFileName
REAL(8) maximumSignalPressure

! Cochlea parameters
LOGICAL useConstantQ
REAL(8) ConstantQ

INTEGER stiffness
INTEGER damping
INTEGER, PARAMETER :: LINEAR = 1
INTEGER, PARAMETER :: NONLINEAR = 2
INTEGER, PARAMETER :: NONLIN006 = 6
INTEGER, PARAMETER :: NONLIN007 = 7
INTEGER, PARAMETER :: NONLINVDP = 8
INTEGER, PARAMETER :: HOPF = 9
INTEGER, PARAMETER :: RAYLEIGH = 10
INTEGER, PARAMETER :: HOPV = 11
INTEGER, PARAMETER :: GOLDSTEIN = 3
INTEGER, PARAMETER :: ZWEIGLINEAR = 4
INTEGER, PARAMETER :: ZWEIGNONLINEAR = 5
LOGICAL useActiveDamping			! defines whether damping is active or not (only for 1 thru 7)

LOGICAL useGreenwoodMap

LOGICAL useApexShortcut		!shortcuts apex or not
LOGICAL useEarCanalCoupler				!close Middle Ear or not

INTEGER parameterSet
INTEGER, PARAMETER :: HUMAN = 1
INTEGER, PARAMETER :: GUINEA_PIG = 2

! Graphs parameters
LOGICAL lGetPhase
LOGICAL plotStimulus
LOGICAL plotMembrane
LOGICAL plotCochleagram
LOGICAL plotLegend
LOGICAL plotPhase
LOGICAL plotProfile
INTEGER plotEvery_n_points
INTEGER plotEvery_t_points
LOGICAL preventAliasing
LOGICAL plotPositions
REAL minimumPositionToPlot
REAL maximumPositionToPlot
REAL minimumVelocityToPlot
REAL maximumVelocityToPlot

! Output parameters
CHARACTER(127) OutputDirectory

LOGICAL storePressureEarCanal
LOGICAL storeProfile
LOGICAL storeTesting
LOGICAL storeProbing
LOGICAL storeExtraInfo
LOGICAL storeBinary
CHARACTER(127) PressureEarCanalFileName
CHARACTER(127) ProfileFileName
CHARACTER(127) TestingFileName
CHARACTER(127) ProbingFileName
INTEGER probes(11)

END MODULE ParametersModule