SUBROUTINE Rescale
	USE Declare
	USE GraphsModule
	USE WindowsModule
	USE FilesModule
	USE IFQWIN
	IMPLICIT NONE

	LOGICAL okPressed
	LOGICAL temp
	INTEGER colormap, j, answer, counter
	INTEGER, ALLOCATABLE :: colors (:)
	INTEGER(2), ALLOCATABLE :: horizontal_pixel(:)
	INTEGER(2), ALLOCATABLE :: vertical_pixel(:)
	integer(4) :: SETACTIVEQQresult

	maximumPosition = MAXVAL(positionMatrix)
	minimumPosition = MINVAL(positionMatrix)
	maximumVelocity = MAXVAL(velocityMatrix)
	minimumVelocity = MINVAL(velocityMatrix)

	CALL ShowRescaleDialog (okPressed)

	DO WHILE (okPressed)
		CLOSE (LEGEND_UNIT)
		CLOSE (MEMBRANE_UNIT)
		CLOSE (COCHLEAGRAM_UNIT)
		CLOSE (PROFILE_UNIT)
		CLOSE (PHASE_UNIT)
		
		temp = plotStimulus
		plotStimulus = .FALSE.
		CALL CreateWindows
		plotStimulus = temp
		CALL InitializeLegend(.FALSE.)

		IF (plotMembrane) THEN
			DO t_plotCounter = 0, t_plotpoints-1
				CALL UpdateLegend (100 * t_plotCounter / (t_plotpoints-1))
				CALL PlotMembraneGraph
			ENDDO
		ENDIF

		IF (PlotCochleagram) THEN
			CALL UpdateLegend (0)
			ALLOCATE (colors(n_plotpoints * t_plotpoints), &
										horizontal_pixel(n_plotpoints*t_plotpoints), &
										vertical_pixel(n_plotpoints*t_plotpoints), &
										STAT = err)
			IF (err /= 0) CALL AllocationError
			counter = 0
			DO i = 0, t_plotpoints-1
				DO j = 0, n_plotpoints-1
					counter=counter+1
					horizontal_pixel(counter) = i
					vertical_pixel(counter) = j
					IF (plotPositions) THEN
						colors(counter) = colormap (positionMatrix(j, i), minimumPositionToPlot, maximumPositionToPlot)
					ELSE
						colors(counter) = colormap (velocityMatrix(j, i), minimumVelocityToPlot, maximumVelocityToPlot)
					ENDIF
				ENDDO
			ENDDO
			CALL UpdateLegend (100)
			SETACTIVEQQresult = SETACTIVEQQ (COCHLEAGRAM_UNIT)
			CALL SETPIXELSRGB(counter, horizontal_pixel, vertical_pixel, colors)
			DEALLOCATE (horizontal_pixel)
			DEALLOCATE (vertical_pixel)
			DEALLOCATE (colors)
		ENDIF
	
		CALL PlotProfileGraph
		CALL PlotPhaseGraph

		CALL WriteParameterFile(FN_parameters)
		CALL ShowRescaleDialog (okPressed)
	ENDDO

END SUBROUTINE Rescale