SUBROUTINE UpdateMaximumValue (dlg, id, event)
	USE Declare
	USE GraphsModule
	USE DFLOGM
	IMPLICIT NONE
	INCLUDE 'resource.fd'
	INCLUDE 'dialogInclude'
	REAL newMaximumValue
	CHARACTER(22) text

	ok = DLGGETLOG (dlg, RADIO_plotPositions, plotPositions)

	SELECT CASE (id)
	CASE (RADIO_setLargestAsMax)
		IF (plotPositions) THEN
			newMaximumValue = maximumPosition * 1e9
		ELSE
			newMaximumValue = maximumVelocity * 1e6
		ENDIF
	CASE (RADIO_setCurrentAsMax)
		IF (plotPositions) THEN
			newMaximumValue = maximumPositionToPlot * 1e9
		ELSE
			newMaximumValue = maximumVelocityToPlot * 1e6
		ENDIF
	CASE (RADIO_setNewAsMax)
		newMaximumValue = 0
	END SELECT
	ok = DLGSETCHAR (dlg, EDIT_NewMaximumValue, RealToString (DBLE (newMaximumValue), 3))
END SUBROUTINE UpdateMaximumValue