! Reads Data chunk from wave file with file handler <handler>
! <DataSize> is extracted from this chunk

SUBROUTINE ReadDataChunk (handler)
	USE WaveReadModule
	USE winmm
	IMPLICIT NONE
	INTEGER handler
	EXTERNAL GetLong
	INTEGER(4) GetLong

	IF (WaveFileErrorMessage == "") THEN
		SubChunk.ckid = mmioStringToFOURCC('data'C, 0) 
		IF (mmioDescend(handler, SubChunk, WaveChunk, MMIO_FINDCHUNK) /= MMSYSERR_NOERROR) THEN	!data chunk not found
			WaveFileErrorMessage = CORRUPTWAVEFILE
		ELSE
			DataSize = SubChunk.cksize
			IF (DataSize == 0) THEN	!no data in data chunk
				WaveFileErrorMessage = NODATA
			ENDIF
		ENDIF
	ENDIF

END SUBROUTINE ReadDataChunk