SUBROUTINE FileNameBox (openbox, cpf, FileName)
! if <openbox> then an open file box will be displayed, else a save file box
! <dir> sets the initial directory and returns the final directory
! if <cpf> then box opened for Cochlea Parameter Files else for Wave Files
! <FileName> returns the filename from the box; <FileName> is "" if no file has been selected

	USE ParametersModule
	USE DialogDeclare
	USE MessageModule
	USE COMDLG32
	USE IFPORT, ONLY: GETCWD, CHDIR, SPLITPATHQQ
!	USE IFLIB, ONLY: SPLITPATHQQ

	IMPLICIT NONE
	LOGICAL, INTENT(IN) :: openbox
	LOGICAL, INTENT (IN) :: cpf
	CHARACTER(512), INTENT (OUT) :: FileName
	CHARACTER(3) drive
	CHARACTER(256) audioFilesDir
	CHARACTER(256) name
	CHARACTER(256) ext

	TYPE(T_OPENFILENAME) ofn
	CHARACTER(127) filter
	CHARACTER(4) default_ext
	INTEGER flags, status, ilen
	CHARACTER(127) dir
    integer(4) :: istat
    
	istat = GETCWD (dir) 
	IF (cpf) THEN
		default_ext = "cpf"C
		filter = "Cochlea Parameter files (*.cpf)"C // "*.cpf"C // ""C
		istat= CHDIR (settingsDirectory)
	ELSE
		default_ext = "wav"C
		filter = "Audio files (*.wav)"C // "*.wav"C // ""C
		istat= SPLITPATHQQ (audioFileName, drive, audioFilesDir, name, ext) 
		istat= CHDIR (TRIM(drive)//TRIM(audioFilesDir))
	ENDIF

	FileName = ""C
	flags = OFN_PATHMUSTEXIST .OR. OFN_HIDEREADONLY
	IF (openbox) THEN
		flags = flags .OR. OFN_FILEMUSTEXIST
	ELSE
		flags = flags .OR. OFN_OVERWRITEPROMPT
	ENDIF

	ofn.lStructSize = SIZEOF(ofn)
	ofn.hwndOwner = dlg_main%hwnd
	ofn.hInstance = NULL
	ofn.lpstrFilter = LOC(filter)
	ofn.lpstrCustomFilter = NULL
	ofn.nMaxCustFilter = 0
	ofn.nFilterIndex = 1
	ofn.lpstrFile = LOC(FileName)
	ofn.nMaxFile = SIZEOF(FileName)
	ofn.lpstrFileTitle = NULL
	ofn.nMaxFileTitle = 0
	ofn.lpstrInitialDir = NULL
	ofn.lpstrTitle = LOC(""C)
	ofn.Flags = flags
	ofn.lpstrDefExt = LOC(default_ext)
	ofn.lpfnHook = NULL
	ofn.lpTemplateName = NULL

	IF (openbox) THEN
		status = GetOpenFileName(ofn)
	ELSE
		status = GetSaveFileName(ofn)
	ENDIF

	IF (status == 0) THEN
		FileName = ""
	ELSE
		ilen = INDEX(FileName,CHAR(0)) -1		! Get length of FileName by looking for trailing NUL
		IF (ilen > 127) THEN
			CALL Message (dlg_main%hwnd, FILENAMETOOLONG)
			FileName = ""
		ELSE		
			FileName = FileName(1:ilen)
		ENDIF
		IF (cpf) THEN
			default_ext = "cpf"C
			filter = "Cochlea Parameter files (*.cpf)"C // "*.cpf"C // ""C
			istat= GETCWD (settingsDirectory) 
		ELSE
			default_ext = "wav"C
			filter = "Audio files (*.wav)"C // "*.wav"C // ""C
		ENDIF
	ENDIF
	istat= CHDIR (dir)

END SUBROUTINE