! Centers dialog with handler <dialogHandler> on screen

SUBROUTINE CenterDialog (dialogHandler)
	USE user32
	USE gdi32 

	IMPLICIT NONE
	INTEGER, INTENT(IN) :: dialogHandler

	TYPE (T_RECT) rDialog
    INTEGER wDialog, hDialog
	INTEGER wScreen, hScreen, xNew, yNew
	INTEGER dcScreen
    logical(4) :: status

    ! Get the Height and Width of the dialog box
	status  = GetWindowRect (dialogHandler, rDialog)
	wDialog = rDialog.right - rDialog.left
	hDialog = rDialog.bottom - rDialog.top

    ! Get the display limits
	dcScreen = GetDC (dialogHandler)
	wScreen  = GetDeviceCaps (dcScreen, HORZRES)
	hScreen  = GetDeviceCaps (dcScreen, VERTRES)
	status   = ReleaseDC (dialogHandler, dcScreen)

	xNew = MAX(0, (wScreen - wDialog) / 2)
	yNew = MAX(0, (hScreen - hDialog) / 2)

	status = SetWindowPos (DialogHandler, NULL, xNew, yNew, 0, 0, IOR(SWP_NOSIZE , SWP_NOZORDER))
END SUBROUTINE