! Initializes Main Dialog Box and all the sub dialog boxes

SUBROUTINE InitDialog
	USE DialogDeclare
	USE Declare
	IMPLICIT NONE
	
	EXTERNAL MainSub
	EXTERNAL OKButton, SaveButton, LoadButton

	!Initialize the main dialog box
	ok = DlgInit(DIALOG_MAIN, dlg_main)
	ok = DLGSETSUB(dlg_main, DIALOG_MAIN, MainSub)

	!Set number of tabs
	ok = DLGSETINT(dlg_main, ID_TAB, 6)

	!Set tab labels
	ok = DLGSETCHAR(dlg_main, ID_TAB, "General", 1)
	ok = DLGSETCHAR(dlg_main, ID_TAB, "Compose stimulus", 2)
	ok = DLGSETCHAR(dlg_main, ID_TAB, "Audio file", 3)
	ok = DLGSETCHAR(dlg_main, ID_TAB, "Cochlea", 4)
	ok = DLGSETCHAR(dlg_main, ID_TAB, "Graphs", 5)
	ok = DLGSETCHAR(dlg_main, ID_TAB, "Output", 6)

	!Set tab associated dialog boxes
	ok = DLGSETINT(dlg_main, ID_TAB, TABDLG_GENERAL, 1)
	ok = DLGSETINT(dlg_main, ID_TAB, TABDLG_COMPOSESTIMULUS, 2)
	ok = DLGSETINT(dlg_main, ID_TAB, TABDLG_STIMULUSFILE, 3)
	ok = DLGSETINT(dlg_main, ID_TAB, TABDLG_COCHLEA, 4)
	ok = DLGSETINT(dlg_main, ID_TAB, TABDLG_GRAPHS, 5)
	ok = DLGSETINT(dlg_main, ID_TAB, TABDLG_OUTPUT, 6)

	!Initialize tab dialog boxes
	ok = DlgInit(TABDLG_GENERAL, dlg_tab1)
	ok = DlgInit(TABDLG_COMPOSESTIMULUS, dlg_tab2)
	ok = DlgInit(TABDLG_STIMULUSFILE, dlg_tab3)
	ok = DlgInit(TABDLG_COCHLEA, dlg_tab4)
	ok = DlgInit(TABDLG_GRAPHS, dlg_tab5)
	ok = DlgInit(TABDLG_OUTPUT, dlg_tab6)

	!Set dlg_main button actions
	ok = DLGSETSUB (dlg_main, IDOK, OKButton)
	ok = DLGSETSUB (dlg_main, BUTTON_SaveSettings, SaveButton)
	ok = DLGSETSUB (dlg_main, BUTTON_LoadSettings, LoadButton)

	CALL SetAllValues
	DialogErrorMessage = ""

END SUBROUTINE InitDialog