SUBROUTINE InitCochlea (dlg)

	USE Declare
	USE DialogDeclare
	USE DFLOGM
	IMPLICIT NONE
	TYPE (dialog) dlg
	EXTERNAL ChangedImpedance
	EXTERNAL ChangedFrequencyMap
	EXTERNAL UpdateDampingProfile

	! select parameterSet
	IF (ParameterSet == HUMAN) CALL SetLogToDialog (dlg, RADIO_ModelHuman, .TRUE.)
	IF (ParameterSet == GUINEA_PIG) CALL SetLogToDialog (dlg, RADIO_ModelGuineaPig, .TRUE.)
	ok = DLGSETSUB (dlg, RADIO_ModelHuman, ChangedFrequencyMap)
	ok = DLGSETSUB (dlg, RADIO_ModelGuineaPig, ChangedFrequencyMap)

	! damping profile
	CALL SetLogToDialog (dlg, RADIO_useConstantQ, useConstantQ)
	CALL SetLogToDialog (dlg, RADIO_useNonConstantQ, .NOT. useConstantQ)
	ok = DLGSETSUB (dlg, RADIO_useConstantQ, UpdateDampingProfile)
	ok = DLGSETSUB (dlg, RADIO_useNonConstantQ, UpdateDampingProfile)
	CALL SetRealToDialog (dlg, EDIT_ConstantQ, ConstantQ)

	! stiffness
	ok = DLGSETINT (dlg, COMBO_stiffness, 5, DLG_NUMITEMS)
	ok = DLGSETCHAR (dlg, COMBO_stiffness, "Linear", LINEAR)
	ok = DLGSETCHAR (dlg, COMBO_stiffness, "Nonlinear", NONLINEAR)
	ok = DLGSETCHAR (dlg, COMBO_stiffness, "Goldstein", GOLDSTEIN)
	ok = DLGSETCHAR (dlg, COMBO_stiffness, "Zweig linear", ZWEIGLINEAR)
	ok = DLGSETCHAR (dlg, COMBO_stiffness, "Zweig nonlinear", ZWEIGNONLINEAR)
	ok = DLGSETINT (dlg, COMBO_stiffness, stiffness, DLG_STATE)
	ok = DLGSETSUB (dlg, COMBO_stiffness, ChangedImpedance)
	
	! damping
	ok = DLGSETINT (dlg, COMBO_damping, 11, DLG_NUMITEMS)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Linear", LINEAR)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Nonlinear", NONLINEAR)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Nonlin006", NONLIN006)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Nonlin007", NONLIN007)
	ok = DLGSETCHAR (dlg, COMBO_damping, "vanderPol", NONLINVDP)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Rayleigh", RAYLEIGH)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Hopf", HOPF)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Hopfv", HOPV)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Goldstein", GOLDSTEIN)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Zweig linear", ZWEIGLINEAR)
	ok = DLGSETCHAR (dlg, COMBO_damping, "Zweig nonlinear", ZWEIGNONLINEAR)
	ok = DLGSETINT (dlg, COMBO_damping, damping, DLG_STATE)
	ok = DLGSETSUB (dlg, COMBO_Damping, ChangedImpedance)

	! active damping
	CALL SetLogToDialog (dlg, CHECK_useActiveDamping, useActiveDamping)
	ok = DLGSETSUB (dlg, Check_useActiveDamping, ChangedImpedance)

	! frequency map
	CALL SetLogToDialog (dlg, RADIO_useExponentialMap, .NOT. useGreenwoodMap)
	CALL SetLogToDialog (dlg, RADIO_useGreenwoodMap, useGreenwoodMap)
	ok = DLGSETSUB (dlg, RADIO_useExponentialMap, ChangedFrequencyMap)
	ok = DLGSETSUB (dlg, RADIO_useGreenwoodMap, ChangedFrequencyMap)

	! cochlea options
	CALL SetLogToDialog (dlg, CHECK_useApexShortcut, useApexShortcut)
	CALL SetLogToDialog (dlg, CHECK_useEarCanalCoupler, useEarCanalCoupler)

END SUBROUTINE InitCochlea