SUBROUTINE InitComposeStimulus (dlg)

	USE Declare
	USE DialogDeclare
	USE WaveReadModule
	USE DFLOGM
	IMPLICIT NONE
	TYPE (dialog) dlg
	EXTERNAL ChangedStimulus
	EXTERNAL Signal1Check
	EXTERNAL Signal2Check
	EXTERNAL Signal3Check
	EXTERNAL UpdateSignal

	! Radio buttons
	IF (useAudioFile) THEN
		ok = DLGSETLOG (dlg, RADIO_useAudioFile, .TRUE.)
	ELSE
		ok = DLGSETLOG (dlg, RADIO_composeStimulus, .TRUE.)
	ENDIF
	ok = DLGSETSUB (dlg, RADIO_composeStimulus, ChangedStimulus)
	ok = DLGSETSUB (dlg, RADIO_useAudioFile, ChangedStimulus)
 
	! signal 1 values
	CALL SetRealToDialog (dlg, EDIT_signal1Period, 1d3/signal1Frequency)
	ok = DLGSETSUB (dlg, EDIT_signal1Period, UpdateSignal)
    CALL SetRealToDialog (dlg, EDIT_signal1Frequency, signal1Frequency)
	ok = DLGSETSUB (dlg, EDIT_signal1Frequency, UpdateSignal)
	CALL SetRealToDialog (dlg, EDIT_signal1Phase, signal1Phase)
	CALL SetRealToDialog (dlg, EDIT_signal1Level, signal1Level)
	CALL SetLogToDialog (dlg, CHECK_useSignal1, useSignal1)
	ok = DLGSETSUB (dlg, CHECK_useSignal1, Signal1Check)

	! signal 2 values
	CALL SetRealToDialog (dlg, EDIT_signal2Period, 1d3/signal2Frequency)
	ok = DLGSETSUB (dlg, EDIT_signal2Period, UpdateSignal)
	CALL SetRealToDialog (dlg, EDIT_signal2Frequency, signal2Frequency)
	ok = DLGSETSUB (dlg, EDIT_signal2Frequency, UpdateSignal)
	CALL SetRealToDialog (dlg, EDIT_signal2Phase, signal2Phase)
	CALL SetRealToDialog (dlg, EDIT_signal2Level, signal2Level)
	CALL SetLogToDialog (dlg, CHECK_useSignal2, useSignal2)
	ok = DLGSETSUB (dlg, CHECK_useSignal2, Signal2Check)

	! signal 3 values
	CALL SetRealToDialog (dlg, EDIT_signal3Period, signal3Period * 1d3)
	CALL SetRealToDialog (dlg, EDIT_signal3Duration, signal3Duration * 1d3)
	CALL SetRealToDialog (dlg, EDIT_signal3Level, signal3Level)
	CALL SetLogToDialog (dlg, CHECK_useSignal3, useSignal3)
	ok = DLGSETSUB (dlg, CHECK_useSignal3, Signal3Check)

	CALL SetRealToDialog (dlg, EDIT_OnsetDuration, OnsetDuration * 1d3)

END SUBROUTINE InitComposeStimulus
