SUBROUTINE InitOutput (dlg)

	USE Declare
	USE DialogDeclare
	USE DFLOGM
	IMPLICIT NONE
	TYPE (dialog) dlg
	EXTERNAL UpdateFrequencies
	EXTERNAL UpdateOutput

	ok = DLGSETCHAR (dlg, EDIT_outputDirectory, TRIM(outputDirectory))

	CALL SetLogToDialog (dlg, CHECK_storePressureEarCanal, storePressureEarCanal)
	ok = DLGSETSUB (dlg, CHECK_storePressureEarCanal, UpdateOutput)
	ok = DLGSETCHAR (dlg, EDIT_PressureEarCanalFileName, TRIM(PressureEarCanalFileName))

	CALL SetLogToDialog (dlg, CHECK_storeProfile, storeProfile)
	ok = DLGSETSUB (dlg, CHECK_storeProfile, UpdateOutput)
	ok = DLGSETCHAR (dlg, EDIT_profileFileName, TRIM(profileFileName))

	CALL SetLogToDialog (dlg, CHECK_storeTesting, storeTesting)
	ok = DLGSETSUB (dlg, CHECK_storeTesting, UpdateOutput)
	ok = DLGSETCHAR (dlg, EDIT_TestingFileName, TRIM(TestingFileName))

	CALL SetLogToDialog (dlg, CHECK_storeProbing, storeProbing)
	ok = DLGSETSUB (dlg, CHECK_storeProbing, UpdateOutput)
	ok = DLGSETCHAR (dlg, EDIT_ProbingFileName, TRIM(ProbingFileName))

	CALL SetLogToDialog (dlg, CHECK_storeExtraInfo, storeExtraInfo)
	CALL SetLogToDialog (dlg, CHECK_storeBinary, storeBinary)
	ok = DLGSETSUB (dlg, CHECK_storeBinary, UpdateOutput)

	CALL SetIntegerToDialog (dlg, EDIT_probe1, probes(1))
	CALL SetIntegerToDialog (dlg, EDIT_probe2, probes(2))
	CALL SetIntegerToDialog (dlg, EDIT_probe3, probes(3))
	CALL SetIntegerToDialog (dlg, EDIT_probe4, probes(4))
	CALL SetIntegerToDialog (dlg, EDIT_probe5, probes(5))
	CALL SetIntegerToDialog (dlg, EDIT_probe6, probes(6))
	CALL SetIntegerToDialog (dlg, EDIT_probe7, probes(7))
	CALL SetIntegerToDialog (dlg, EDIT_probe8, probes(8))
	CALL SetIntegerToDialog (dlg, EDIT_probe9, probes(9))
	CALL SetIntegerToDialog (dlg, EDIT_probe10, probes(10))
	CALL SetIntegerToDialog (dlg, EDIT_probe11, probes(11))

	ok = DLGSETSUB (dlg, EDIT_probe1, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe2, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe3, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe4, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe5, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe6, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe7, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe8, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe9, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe10, UpdateFrequencies)
	ok = DLGSETSUB (dlg, EDIT_probe11, UpdateFrequencies)

END SUBROUTINE InitOutput