! Certain options can not be chosen independently.
! If ActiveDamping is chosen, damping will be set to nonlinear
! If a Zweig damping is chosen stiffness is set to the same value and vice versa and a constant Q = ZweigQ shall be set
! If another damping is chosen and stiffness is still Zweig, stiffness will default to Linear and vice versa and Q will be set to normalQ
! ALLOW GOLDSTEIN DAMPING with LINEAR STIFFNESS, BUT: GOLSTEIN STIFFNESS only with GOLDSTEIN DAMPING


SUBROUTINE ChangedImpedance (dlg, id, event)
	USE DFLOGM
	USE Declare
	USE DialogDeclare
	IMPLICIT NONE
	INCLUDE 'DialogInclude'
	INTEGER temp
	LOGICAL l_temp

	IF (id==CHECK_useActiveDamping) THEN
		ok = DLGGETLOG (dlg, id, l_temp)
		IF (l_temp) THEN
	        ok = DLGGETINT (dlg, COMBO_damping, temp, DLG_STATE)
	        IF (temp == NONLINEAR) THEN
	            ok = DLGSETINT (dlg, COMBO_Damping, NONLINEAR, DLG_STATE)
	        ELSE IF (temp == NONLIN006) THEN
	            ok = DLGSETINT (dlg, COMBO_Damping, NONLIN006, DLG_STATE)
	        ELSE IF (temp == NONLIN007) THEN 
	            ok = DLGSETINT (dlg, COMBO_Damping, NONLIN007, DLG_STATE)
	        ELSE IF (temp == NONLINVDP) THEN 
	            ok = DLGSETINT (dlg, COMBO_Damping, NONLINVDP, DLG_STATE)
	        ELSE
	            ok = DLGSETLOG (dlg, CHECK_useActiveDamping, .FALSE.)
	        ENDIF			
		!	ok = DLGGETINT (dlg, COMBO_Stiffness, temp, DLG_STATE)
		!	IF (temp == ZWEIGLINEAR   ) ok = DLGSETINT (dlg, COMBO_Stiffness, LINEAR, DLG_STATE)
		!	IF (temp == ZWEIGNONLINEAR) ok = DLGSETINT (dlg, COMBO_Stiffness, LINEAR, DLG_STATE)
		ENDIF
	ELSEIF (id==COMBO_Damping) THEN
		ok = DLGGETINT (dlg, COMBO_Stiffness, temp, DLG_STATE) 
!		IF (temp == ZWEIGLINEAR .OR. temp == ZWEIGNONLINEAR .OR. temp == GOLDSTEIN) THEN
		IF (temp == ZWEIGLINEAR .OR. temp == ZWEIGNONLINEAR ) THEN
		    ok = DLGSETINT (dlg, COMBO_Stiffness, LINEAR, DLG_STATE)
		ENDIF
		
		ok = DLGGETINT (dlg, id, temp, DLG_STATE)
		IF (temp == ZWEIGLINEAR   ) ok = DLGSETINT (dlg, COMBO_Stiffness, ZWEIGLINEAR, DLG_STATE)
		IF (temp == ZWEIGNONLINEAR) ok = DLGSETINT (dlg, COMBO_Stiffness, ZWEIGNONLINEAR, DLG_STATE)
!		IF (temp == GOLDSTEIN     ) ok = DLGSETINT (dlg, COMBO_Stiffness, GOLDSTEIN, DLG_STATE)
!		IF (temp == GOLDSTEIN     ) ok = DLGSETINT (dlg, COMBO_Stiffness, GOLDSTEIN, DLG_STATE)

		IF (temp /= NONLINEAR .AND. temp /= NONLIN006 .AND. temp /= NONLIN007 .AND. temp /= NONLINVDP ) THEN 
		  ok = DLGSETLOG (dlg, CHECK_useActiveDamping, .FALSE.)
        ENDIF

	ELSEIF (id==COMBO_Stiffness) THEN
		ok = DLGGETINT (dlg, COMBO_Damping, temp, DLG_STATE)
!		IF (temp == ZWEIGLINEAR .OR. temp == ZWEIGNONLINEAR .OR. temp == GOLDSTEIN) THEN 
		IF (temp == ZWEIGLINEAR .OR. temp == ZWEIGNONLINEAR ) THEN 
		    ok = DLGSETINT (dlg, COMBO_Damping, LINEAR, DLG_STATE)
		ENDIF
		
		ok = DLGGETINT (dlg, id, temp, DLG_STATE)
		IF (temp == ZWEIGLINEAR   ) ok = DLGSETINT (dlg, COMBO_Damping, ZWEIGLINEAR, DLG_STATE)
		IF (temp == ZWEIGNONLINEAR) ok = DLGSETINT (dlg, COMBO_Damping, ZWEIGNONLINEAR, DLG_STATE)
		IF (temp == GOLDSTEIN     ) ok = DLGSETINT (dlg, COMBO_Damping, GOLDSTEIN, DLG_STATE)

		ok = DLGGETINT (dlg, COMBO_Damping, temp, DLG_STATE)
		IF (temp == ZWEIGLINEAR .OR. temp == ZWEIGNONLINEAR .OR. temp == GOLDSTEIN) THEN 
		    ok = DLGSETLOG (dlg, CHECK_useActiveDamping, .FALSE.)
        ENDIF
	ENDIF

	ok = DLGGETINT (dlg, COMBO_Damping, temp, DLG_STATE)
	IF (temp == ZWEIGLINEAR .OR. temp == ZWEIGNONLINEAR) THEN
		CALL SetLogToDialog (dlg, RADIO_useConstantQ, .TRUE.)
		ok = DLGSETLOG (dlg, EDIT_ConstantQ, .TRUE., DLG_ENABLE)
		CALL SetRealToDialog (dlg, EDIT_ConstantQ, ZweigQ)
	ELSE
		IF (GetRealFromDialog (dlg, EDIT_ConstantQ) < 0) CALL SetRealToDialog (dlg, EDIT_ConstantQ, Q_constant_default)
	ENDIF

END SUBROUTINE ChangedImpedance