SUBROUTINE UpdateFrequencies (dlg, id, event)
	USE DFLOGM
	USE Declare
	USE DialogDeclare
	IMPLICIT NONE
	INCLUDE 'DialogInclude'
	CHARACTER(12) strings(11)
	REAL(8) frequency
	REAL(8) x1
	REAL(8) x_
	
	CALL GetAllValues
	bm_length = cochleaLength(parameterSet) - helicotremaWidth(parameterSet)
	dx = bm_length / n

	DO i = 1, 11
		IF (probes(i) > 0 .AND. probes(i) <= n) THEN
			x_ = dx * probes(i)
			IF (useGreenwoodMap) THEN
				frequency = f_base_Greenwood_map(parameterSet) * 10 ** (-kappa_Greenwood_map(parameterSet) * x_) - apex_corr_Greenwood_map(parameterSet)
			ELSE	! exponential
				frequency = f_base_exp_map(parameterSet) * 10 ** (-kappa_exp_map(parameterSet) * x_)
			ENDIF
			strings(i) = IntToString(INT(frequency))
		ELSE
			strings(i) = ""
		ENDIF
	ENDDO

	ok = DLGSETCHAR (dlg, TEXT_Frequency1, TRIM(strings(1)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency2, TRIM(strings(2)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency3, TRIM(strings(3)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency4, TRIM(strings(4)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency5, TRIM(strings(5)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency6, TRIM(strings(6)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency7, TRIM(strings(7)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency8, TRIM(strings(8)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency9, TRIM(strings(9)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency10, TRIM(strings(10)))
	ok = DLGSETCHAR (dlg, TEXT_Frequency11, TRIM(strings(11)))

END SUBROUTINE UpdateFrequencies