! Check if FMT-values, read from header of wave file,
! are valid in general and supported by the routines used further on
! If not, <waveFileErrorMessage> is set.

SUBROUTINE CheckFMTvalues
	USE WaveReadModule
	IMPLICIT NONE

	IF (WaveFileErrorMessage == "") THEN

		IF (FormatTag /= 1) THEN
			WaveFileErrorMessage = COMPRESSEDWAVEFILE

		ELSEIF (Channels < 1 .OR. SamplesPerSec == 0 .OR. AvgBytesPerSec == 0 .OR. BytesPerSample < 1) THEN
			WaveFileErrorMessage = CORRUPTWAVEFILE

		ELSEIF (Channels>3) THEN
			WaveFileErrorMessage = TOOMANYCHANNELS

		ELSEIF (SamplesPerSec<0) THEN
			WaveFileErrorMessage = TOOMANYSAMPLESPERSEC

		ELSEIF (AvgBytesPerSec<0) THEN
			WaveFileErrorMessage = TOOMANYAVGBYTESPERSEC

		ELSEIF (BytesPerSample == 3 .OR. BytesPerSample > 4) THEN
			WaveFileErrorMessage = WRONGNUMBEROFBITSPERSAMPLE

		ELSEIF (Channels ==3 ) THEN	!No Error, but info will be displayed
			InfoMessage = CONTAINS3CHANNELS

		ENDIF
	ENDIF
END SUBROUTINE CheckFMTvalues