program FIGURES

! includes automatic ABCD mixing, usinf ABCD program as a subroutine

use IFQWIN
use IFCORE
use IFPORT
use my_rgb
use GraphParams
use InitiateCoch
use InitiateOae99

implicit NONE

logical    :: lsecondtime
logical*1  :: l_oldp, l_pt
logical*1  :: l_noprobe, l_nostim, l_pon, l_poff
logical*1  :: l_pearcan, l_profile, l_v, l_read
real(4), dimension(8192) :: x0
real(4), allocatable :: xx(:), yy(:)
real(4)    ::  xlcm, ylcm, ydmp, h, hcm, dtxx
real(8)    :: probe_window, phi, kprobeduration
real(4)     :: local_ymax
integer(4) :: idum4, old_rgb_color
integer(4) :: n0, n1, n01
integer(4) :: i1, i1max, ilabel, j7 
integer(4) :: nn, mode
integer*2  :: idum2,  irow
character(len=5)  :: txtn
character(len=1)  :: ch='a', cyn
!character(len=46)  :: txtp
character(len=64) :: file_x
character(len=80), dimension(6) :: C
character(len=80), dimension(24):: txt
character(len=40), dimension(6) :: Ctext
character(len=10), parameter :: pearcan='pearcan.dt'
character(len=10), parameter :: param  ='newpar.dat'
character(len=10), parameter :: profile='profile.dt'
character(len=15) :: fname
record /rccoord/ rc

namelist /coch0/   nt_me, dt, s_r_factor, s_x_factor, x_0
namelist /cochlea/ n,BM_impedance_factor,FREQUENCY_MAP,DAMPING_PROFILE
namelist /stimpars/ t0,StimulusPeriod,ProbePeriod,L_stim,L_probe		&
&		,probe_onset_duration,num_sec_tot,l_coupler
namelist /nonlinearity/ NonLin,alpha
namelist /nonlin2/ beta  
namelist /nonlin3/ gamma
namelist /nonlin4/ d_factor
common /fname1/ fname


10 continue
lsecondtime=.false.
l_noprobe =.false.

old_rgb_color=gettextcolorrgb()

!---------------12345678901234567890123456789012345678901234567890-----

200 continue
xlcm=14.
ylcm=10.

400 continue
idum4=setbkcolorrgb(my_rgb_WHITE)	
call clearscreen($GCLEARSCREEN)

allocate(xx(8192),yy(8192))
write(txt(1),'("Data for this Figure") ') 
!read(*,*)
irow=1
idum2=settextcolorrgb(my_rgb_BLUE)
call outtext(txt(1)(:LEN_TRIM(txt(1))))
idum2=settextcolorrgb(my_rgb_BLACK)
call settextposition(2,1,rc)

call outtext('new EC-data file [n]: ')
read(*,'(BN,A1)') cyn
l_read= cyn .eq. 'y' .or. cyn .eq. 'Y' .or. cyn.eq.'j'

if (.not. l_read) then
    call outtext('Data file XY-values: ')
    read(*,'(A64)') file_x
else
    print*,'call abcd'
    call abcd
    file_x = fname
end if
    
l_pearcan=INDEX(file_x,pearcan)/=0 .OR. INDEX(file_x,'.dt')/=0
l_profile=INDEX(file_x,profile)/=0
l_oldp=l_pearcan .or. l_profile
     
if (l_oldp) then
   open(6,file=param)
else
   open(6,file=file_x)
end if  
call settextposition(3,1,rc) 
call outtext('reading stimulus parameters . . . .')
read (6,coch0)
read (6,cochlea)							 
call settextposition(4,1,rc) 
call outtext ('cochlea read')
read (6,stimpars)
call settextposition(5,1,rc) 
call outtext ('stimpars read')
call settextposition(6,1,rc) 
print*,'Lstim',L_stim
print*,'Lprobe',L_probe

!read(*,*)

read (6,nonlinearity)
call settextposition(7,1,rc) 
call outtext ('nonl read')
if (l_oldp) then
   close(6)
   open(6,file=file_x)
else
   rewind 6
end if   

write(txtn,'(f5.2)') StimulusPeriod*1.e3
call settextposition(8,1,rc) 
call outtext('StimulusPeriod = '//txtn//' ms')

if(l_pearcan)then
	n1=NINT((INT4(T_sect_default/StimulusPeriod)+0.5)*StimulusPeriod/dt)  !=/dt
!	if (l_oldp) n1=n1*4
else if(l_profile) then
    n1=n 
else
	n1=0
end if

call settextposition(9,1,rc) 
if (n1==0) then
    call outtext('Number of XY data points: ') 
else
	write(txtn,'(i5)') n1
	call outtext('Number of XY data points ['//txtn//']: ')
endif
read(*,'(BN,I5)') n0
if(n0.le.2) n0=n1

n1=0
call outtext('Begin at number [1]: ')
read(*,'(BN,I5)') n1
if(n1.le.1) n1=1  

if(n0.gt.4000) then
   i1max=1+int((n0-1)/4000)
   n01=int(n0/i1max)
   n0=MIN(4000,n01)
else
   i1max=1	
end if

!call pl_open(0)

402 continue
if(lsecondtime)then
 call settextwindow(1_2,1_2,maxrow,maxcol)
 call settextposition(1_2,1_2,rc)
endif

call outtext('reading stimulus data . . . .')
if(n1.gt.1) then
  do i=1,n1-1
    if( l_profile ) then
	  read(6,*) xx(1), yy(1), ydmp
    else
      read(6,*) xx(1), yy(1)
    endif
  enddo
end if

if( l_profile .and. .not. lsecondtime ) then
  call outtext('select amplitude profile [a, (default)]')
  call outtext('    or velocity profile [v]: ')
  read(*,'(BN,A)') ch
  l_v = (ch=='v' .or. ch == 'V') 
end if

do i=1,n0
  do i1=1,i1max
    if( l_profile ) then
      if(l_v) then
        read(6,*) xx(i), yy(i), ydmp
	  else
        read(6,*) xx(i), ydmp, yy(i)
	  endif
	else
      read(6,*) xx(i), yy(i)
	end if
  enddo
enddo
if (l_pearcan) then
	x0=xx(1)
	xx=xx-x0
end if


call outtext('done')

!c 
!c       LABEL BLOK
!c

Ctext(1)='time (ms)'
if(l_pearcan) then
	Ctext(2)='p_{ec}  (Pa)' !'p_ec  (Pa)'   !
else if (l_profile) then
	if(l_v)then
		Ctext(2)='BM ampltude profile (m)'
	else
		Ctext(2)='BM velocity profile (m/s)'
	endif 
else
	Ctext(2)='y-value' 
endif
if (num_sec_tot.ge.10) then
       assign 311 to ilabel
!		Ctext(2)='BM velocity profile (m/s)'
    else
       assign 310 to ilabel
end if
write(txt(20),ilabel) num_sec_tot

if (INT(L_stim).ge.10) then
    if (INT(L_stim).ge.100) then
assign 312 to ilabel
    else
assign 311 to ilabel
    end if
else 
assign 310 to ilabel
end if
write(txt(21),ilabel) nint(L_stim)

call outtext('')
print*,'Lstim',L_stim
print*,'Lprobe',L_probe

!read(*,*)

if (L_probe.ge.0)then
  if (INT(L_probe).ge.10) then
    if (INT(L_probe).ge.100) then
		assign 312 to ilabel
    else
		assign 311 to ilabel
    end if
  else 
	assign 310 to ilabel
  end if
else 
  if (INT(L_probe).le.-10) then
    if (INT(L_probe).le.-100) then
	   if(int(L_probe).le.-150) then
		  l_noprobe=.true.
	   else
		  assign 313 to ilabel
	   end if
    else
		assign 312 to ilabel
    end if
  else 
	assign 311 to ilabel
  end if
end if
if(.not.l_noprobe) write(txt(22),ilabel) nint(L_probe)
l_nostim=L_stim.lt.-150.

write(txt(23),314) BM_impedance_factor
310     format(i1)
311     format(i2)
312     format(i3)
313     format(i4)
314     format(f4.1)

if(l_noprobe) then
	if(l_nostim) then
		txt(24)='no stimulus'
	else
		txt(24)= 'L$_B$ = '//txt(21)(:LEN_TRIM(txt(21)))//     &
&           ' dB, BMfactor:'//txt(23)(:LEN_TRIM(txt(23)))
	endif	
else
	if(l_nostim) then
	    txt(24)= 'L$_p$ = '//txt(22)(:LEN_TRIM(txt(22)))//     &
&			' dB, BMfactor:'//txt(23)(:LEN_TRIM(txt(23)))
	else
		txt(24)= 'L$_b$ = '//txt(21)(:LEN_TRIM(txt(21)))//		&
&            ', L$_p$ = '//txt(22)(:LEN_TRIM(txt(22)))//		&
&            ' dB, BMfactor:'//txt(23)(:LEN_TRIM(txt(23)))
	endif
endif
      

select case (NonLin)
case (1)  ! LIN damping   and      LIN stiffness
  Ctext(3)='linear'
case (2)  ! Pass cosh damping and  LIN stiffness
  Ctext(3)='passive NL #2'
case (3)  ! Act cosh/sinh damping and LIN stiffness 
  Ctext(3)='active NL #3'
case (4)  ! Pass cosh damping and NL stiffness
  Ctext(3)='passive NL damping & NL stiffness #4'
case (5)  ! Act cosh/sinh damping and NL stiffness 
  Ctext(3)='active NL damping & NL stiffness #5'
case (6)  ! LIN damping   and   nl stiffness svn
  Ctext(3)='NL stiffness #6'
case (7)  ! NL (goldstein) damping and LIN stiffness
  Ctext(3)='NL damping #7'
case (8)  ! NL damping and NL stiffness (goldstein)
  Ctext(3)='NL damping & stiffness #8'
case (9)  ! new NL damping 
  Ctext(3)='NL damping 006'
end select

Ctext(4)=txt(24)(:LEN_TRIM(txt(24)))
write(Ctext(5),315) 1./stimulusperiod*1.e-3, 1./ProbePeriod*1.e-3
315     format('f_b =',f5.2,', f_p=',f5.2,' kHz')

!idum2=setvideomode($DEFAULTMODE)

hcm=.5
call pl_open(0)

do 778 j7=1,6
C(j7)=' '
C(j7)=Ctext(j7)(:LEN_TRIM(Ctext(j7)))
778     continue

nn=n0
xl=xlcm
yl=ylcm
h=hcm
mode=0
xx=xx*1.d3 !van seconde naar milliseconde

if (l_profile) then
	call graphs(linlog,xx,yy,nn,xl,yl,h,C,mode)
else
	call graphs(linlin,xx,yy,nn,xl,yl,h,C,mode)
endif

889   read(*,*)

call outtext('mark probe? [n]: ')
read(*,'(BN,A1)') cyn
l_read= cyn .eq. 'y' .or. cyn .eq. 'Y' .or. cyn.eq.'j'

if (l_read) then
    local_ymax= maxval(yy)
    yy=0
    probe_window = 0.
    probe_duration = DBLE(DINT(DINT(40.d-3/ProbePeriod)/2.) )*ProbePeriod
    probe_duration = probe_duration * 1.e3  !!van s maar ms 
    dtxx = (xx(2)-xx(1)) 
    kprobeduration=probe_duration/dtxx
    do i= 1,nn
        if (i.lt.4./dtxx) then
          phi =  (i*dtxx)/ 4. * PI
          probe_window= parh - parh * cos(phi)
        else if (i.gt.kprobeduration .AND. i.lt.(kprobeduration+4./dtxx) ) then
          phi =  (probe_duration - i*dtxx)/4. * PI
          probe_window=  parh + parh*dcos(phi)
        else if (i.le.kprobeduration) then 
            probe_window = par1
        else
            probe_window = 0.
        end if
!      yy(i)=(probe_window/4.)*local_ymax - ylcm/2. !moet schaalfactor tussen
      yy(i)=(probe_window/4.)*local_ymax - local_ymax
      end do
  mode=00021
  call graphs(linlin,xx,yy,nn,xl,yl,h,C,mode)
end if
read(*,*)

call pl_close

lgrid=.false.
lsubtick=.false.
idum4=setbkcolorrgb(my_rgb_WHITE)	
call clearscreen($GCLEARSCREEN)
      
call outtext('Once more? [n]: ')
read(*,'(BN,A1)') cyn
l_read= cyn .eq. 'y' .or. cyn .eq. 'Y' .or. cyn.eq.'j'

l(1)=.not. l_read
if(.not.l(1)) then
 n1=1
 lsecondtime=.true.
 if(l_profile) then
   l_v= .not.l_v
   rewind(6)
 end if
 goto 402
end if

!call pl_close
close(6)

stop


CONTAINS

subroutine ABCD

IMPLICIT NONE

logical*1  :: l_oldp
logical*1  :: l_noprobe, l_nostim
!real(4), dimension(8192) :: xx, yy
real(4)    ::  xlcm, ylcm, ydmp, h, hcm
real(8)    ::  tbuf
real(8), allocatable ::  pEC_local(:), p_residue(:)
integer(4) :: idum4, old_rgb_color
integer(4) :: n0, n1, n01
integer(4) :: i1, i1max, ilabel, j7 
integer(4) :: nn, mode
integer(4) :: npnt, ipnt
integer*2  :: idum2,  irow
character(len=5)  :: txtn
character(len=64) :: file_x
character(len=80), dimension(6) :: C
character(len=80), dimension(24):: txt
character(len=40), dimension(6) :: Ctext
character(len=10), parameter :: pearcan='pearcan.dt'
character(len=10), parameter :: param  ='newpar.dat'
character(len=10), parameter :: profile='profile.dt'
character(len=15) :: fname
character(len=13) :: fcnt='countfile.dat'
integer(4) :: ncountfile
record /rccoord/ rc

namelist /coch0/ nt_ME, dt, s_r_factor, s_x_factor, x_0
namelist /init/  l_init,l_store,l_screenplot,l_out, T_max
namelist /cochlea/ n,BM_impedance_factor,FREQUENCY_MAP
namelist /stimpars/ t0,StimulusPeriod,ProbePeriod,L_stim,L_probe		&
&		,probe_onset_duration,num_sec_tot,l_coupler
namelist /nonlinearity/ NonLin,alpha
namelist /nonlin2/ beta  
namelist /nonlin3/ gamma
namelist /countfile/ ncountfile
common /fname1/ fname

open (2,file='newpar.dat') !until 280596:params.dat

read (2,coch0)
read (2,init)
read (2,cochlea)
read (2,stimpars)
read (2,nonlinearity)
read (2,nonlin2)
read (2,nonlin3)
read (2,nonlin4)
close(2)


open (3,file=fcnt)
read (3,countfile)
close(3)

write(fname,111)      &
	&   NonLin                                &
	&   ,idnint(L_stim/1.d1)				  &
    &   ,idnint(abs(L_probe)/1.d1)			  &
    &   ,num_sec_tot						  &
    &   ,idnint(probe_onset_duration*1.d3) 	  &
    &   ,idnint(BM_impedance_factor)		  &
	&   ,FREQUENCY_MAP						  &
	&   ,idnint(dt*2.d6)                      &   
    &   ,nint(n/100.)						  &
    &   ,nint(0.010/StimulusPeriod) 				  &
	&   ,MOD(ncountfile,16)
111  format(Z1,Z1,Z1,Z1,Z1,Z1,Z1,Z1,Z1,I2.2'.dt',Z1)

print*,fname
open (3,file='pearcan.dt') 
open (4,file=fname)
T_section   = StimulusPeriod*DBLE(INT(T_sect_default/StimulusPeriod)+0.5)
npnt     =  NINT(T_section/dt) !*400000) !=T_section/dt!!!
!npnt = 1000*nint(float(npnt)/1000.)
print*,npnt, T_section
read(*,*)
ncountfile=ncountfile+1

allocate (pEC_local(npnt+10), p_residue(npnt+10))

!: +A
do ipnt=1,npnt
   read(3,*) tbuf,p_residue(ipnt)
enddo   

!: -B
do ipnt=1,npnt
   read(3,*) tbuf,pEC_local(ipnt)
   p_residue(ipnt)=p_residue(ipnt)-pEC_local(ipnt)
enddo   

!: -C
do ipnt=1,npnt
   read(3,*) tbuf,pEC_local(ipnt)
   p_residue(ipnt)=p_residue(ipnt)-pEC_local(ipnt)
enddo   

!: +D
do ipnt=1,npnt
   read(3,*) tbuf,pEC_local(ipnt)
   p_residue(ipnt)=p_residue(ipnt)+pEC_local(ipnt)
   write(4,*) ipnt*sngl(dt),sngl(p_residue(ipnt))
enddo   

close(3)

write (4,coch0)
write (4,init)
write (4,cochlea)

write (4,stimpars)
write (4,nonlinearity)
write (4,nonlin2)
write (4,nonlin3)
write (4,nonlin4)
close (4)

open (2,file=fcnt)
write(2,countfile)
close(2)
deallocate (pEC_local, p_residue)


end subroutine

end






