MODULE GraphParams
use IFQWIN
use MyGraphs

IMPLICIT NONE
SAVE

type (windowconfig) wc
type (windowconfig) wc_store
logical(4) :: status

character(len=1)  :: cc
character(len=1)  :: CXYZ
character(len=1), parameter :: $hX = 'x'
character(len=1), parameter :: $hY = 'y'
character(len=1), parameter :: $vZ = 'z'
character(len=80) :: C1, C2, C3
character(len=17), parameter :: cpi  =' $\(\times2\pi\)$'
character(len=25), parameter :: c360 =' $\(\times360\degree\)$' 
character(len=24), dimension(3)  :: flist, flistexp
character(len=40), dimension(20) :: cs, lcs, lscsc
character(len=80), dimension(20) :: mtscr, mtps  !karakter substring
character(len=12) :: thisEPSfilename
character(len=12) :: thisPSfilename

logical, dimension(10)  :: l
logical, dimension(4)   :: lgraph_type
logical, dimension(2)   :: lkpi 
logical, dimension(20)  :: lmtscr,  lmtps   !true=>math, false=>text
logical, dimension(4)   :: ltb

logical  :: linear_x !linx 
logical  :: linear_y !liny
logical  :: linear_z !linz
logical  :: li
logical  :: langlex
logical  :: langlez
logical  :: lpi
logical  :: lncorr
logical  :: lmark
logical  :: lgrid
logical  :: lsubtick
logical  :: lreset_ticks
logical  :: lx, ly
logical  :: lmem
logical  :: lxlines
logical  :: lylines
logical  :: lsigmahor
logical  :: lsigmavert
logical  :: lfirstline
logical  :: lbarcol
logical  :: lquadrant1
logical  :: lquadrant2
logical  :: lquadrant3
logical  :: lquadrant4
logical  :: odd
logical  :: lab 
logical  :: lscreen, lpsfile, leps
logical  :: lpsprint
logical  :: lscreen_only, ltest=.false.
logical  :: lmaxfig
logical  :: lkx
logical  :: lky
logical  :: lkz
logical  :: l2D
logical  :: l3D
logical  :: lreset_x0_y0 !lreset00 
logical  :: lnolimits
logical  :: lpair2figures !generate 2 figures on top, same x-axis, line up frames 
!logical  :: lpair2figure1 
!logical  :: lpair2figure2 
logical  :: lscalem
logical  :: lmima
logical  :: lhist
logical  :: lsymbol
logical  :: lcurve
logical  :: line
logical  :: lineer
logical  :: lcadre
logical  :: lgraph
logical  :: linter

integer(2) :: dummy2
integer(2) :: ihcol
integer(2) :: string_type, it_type
integer(2) :: ncountscr, ncountps      !ttel, mtel, 
integer(2) :: maxrow,maxcol
integer(2) :: jjy
integer(2) :: old_mode, old_adapter
integer(2) :: iof        	

integer(2), parameter ::  imove=3
integer(2), parameter ::  idraw=2
integer(2), parameter ::  mresetor=-3
integer(2), parameter ::  $GRAPH2D = 0
integer(2), parameter ::  $GRAPH2L = 1
integer(2), parameter ::  $GRAPH3D = 2
integer(2), parameter ::  $GRAPH3P = 3
integer(2), parameter ::  minimum_level = -100

integer(2), parameter :: regular_word = 1
integer(2), parameter :: tilted_word  = 2
integer(2), parameter :: letter_by_letter = 3
integer(2), parameter :: rotated_word = 4

integer(2)                :: ncs, nlcs 
integer(2), dimension(20) :: ics, ilcs, lencs, lenlcs
integer(2), dimension(20) :: lenmtscr, lenmtps !lengte string

!integer(4)  :: im
integer(4)  :: dummy   
integer(4)  :: ixyz
integer(4)  :: iout
integer(4)  :: old_col, old_bkcol
integer(4)  :: bbxmin, bbxmax, bbymin, bbymax !BoundingBox

real(4), parameter :: a1_5=0.17609126
real(4), parameter :: a2=0.30103000
real(4), parameter :: a2_5=0.39794001
real(4), parameter :: a3=a1_5+a2
real(4), parameter :: a4=a2+a2
real(4), parameter :: a5=a2_5+a2
real(4), parameter :: a6=a3+a2
real(4), parameter :: a7=0.84509804
real(4), parameter :: a8=a4+a2
real(4), parameter :: a9=0.95424251
real(4), parameter :: pi=3.14159265359
real(4), parameter :: hpi=1.57079632677
real(4), parameter :: tpi=pi+pi
real(4), parameter :: pidegr=180.
real(4), parameter :: dfi=.08726645
real(4), parameter :: fi1=1./18.
real(4), parameter :: fi2=1./12.
real(4), parameter :: fi3=1./6.
real(4), parameter :: fi4=0.25
real(4), parameter :: fi5=1./3.
real(4), parameter :: fi6=0.5
real(4), parameter :: fi7=2./3.
real(4), parameter :: fi8=0.75
real(4), parameter :: fi9=1.
real(4), parameter :: fi10=1.25
real(4), parameter :: fi11=1.5
real(4), parameter :: fi12=2.
real(4), parameter :: fi13=3.
real(4), parameter :: fi14=4.
real(4), parameter :: fi15=5.
real(4), parameter :: hmin = 0.15  !min char hoogte in cm
real(4), parameter :: hmax = 1.00  !max  ..    ..   .. ..  
real(4), parameter :: xlmax = 15.24  !max. lengte x-as in cm
real(4), parameter :: eps_4   = 1.e-3
real(8), parameter :: epsilon = 1.d-3

real(4) :: xl
real(4) :: yl
real(4) :: zl
real(4) :: xlc, xls
real(4) :: ylc, yls
real(4) :: xmin
real(4) :: zmin
real(4) :: xmax
real(4) :: zmax
real(4) :: ymax
real(4) :: ymin
real(4) :: xshift
real(4) :: zshift
real(4) :: xshiftcm2, yshiftcm2 !voor tweede figuur
real(4) :: x10, y10, z10
real(4) :: dlx, dly, dlz
real(4) :: sx, cx
real(4) :: sy, cy
!real(4) :: abscx, abscy
!real(4) :: tsx, tsy
real(4) :: ox,  oz
real(4) :: oox, ooz
real(4) :: xn1, xn2, ox0
real(4) :: yn1, yn2, oy0
real(4) :: zn1, zn2, oz0
real(4) :: yxpixfactor , hx, hz
!real(4)       :: hy      
real(4) :: xangle
real(4) :: yangle
real(4) :: abs_cos_x_angle, sin_x_Q14
real(4) :: abs_cos_y_angle, sin_y_Q14

real(8) :: xrange
real(8) :: dxl,dzl
real(8) :: dhx,dhz
real(8) :: dox,doz
real(8) :: dtx,dtz

real(4), dimension(3)    :: zss
real(4), dimension(3)    :: tst_safe 
real(4), dimension(0:10) :: sd, xs
real(4), dimension(0:10) :: subt
real(8), dimension(2)    :: xlab, zlab

equivalence (l(1),lreset_x0_y0) !lreset00
equivalence (l(2),lscalem)
equivalence (l(3),lmima)
equivalence (l(4),lhist)
equivalence (l(5),lsymbol)
equivalence (l(6),lcurve)
equivalence (l(7),line)
equivalence (l(8),lcadre)
equivalence (l(9),lgraph)
equivalence (l(10),linter)
equivalence (ltb(1),lscreen)
equivalence (ltb(2),lpsprint)
equivalence (ltb(3),lpsfile)
equivalence (ltb(4),leps)

!equivalence (hy,hz)

END MODULE GraphParams

!!!=================================================!!!

MODULE GraphFunctions
SAVE

INTERFACE
subroutine print2001(x4)
real(4) :: x4
end subroutine
END INTERFACE
INTERFACE
subroutine print2002()
end subroutine
END INTERFACE
INTERFACE
subroutine print2003(x4)
real(4) :: x4
end subroutine
END INTERFACE
INTERFACE
subroutine print2004()
end subroutine
END INTERFACE
INTERFACE
subroutine print2005(n4)
integer(4) :: n4
end subroutine
END INTERFACE
INTERFACE
subroutine print2007(x4)
real(4) :: x4
end subroutine
END INTERFACE
INTERFACE
subroutine print3001(x4)
real(4) :: x4
end subroutine
END INTERFACE
INTERFACE
subroutine print4001(x4)
real(4) :: x4
end subroutine
END INTERFACE
INTERFACE
logical function test_char_no(c1)
character(len=1) :: c1
end function
END INTERFACE
INTERFACE
logical function test_char_yes(c1)
character(len=1) :: c1
end function
END INTERFACE
INTERFACE
integer function n_digits_before(x4)
real(4) :: x4
end function
END INTERFACE
INTERFACE
real(4) function LLOGX(x4)
real(4) :: x4
end function
END INTERFACE
INTERFACE
real(4) function LLOGZ(x4)
real(4) :: x4
end function
END INTERFACE
INTERFACE
real(4) function LLOGZ3D(x4)
real(4) :: x4
end function
END INTERFACE
INTERFACE
real(4) function LLOGY3D(x4)
real(4) :: x4
end function
END INTERFACE
INTERFACE
integer(4) function idelta(i)
integer(4) i
end function
END INTERFACE
INTERFACE
real(4) function hvcent(xcent,phixy,zzss,nchar,h,hv,j)
use GraphParams
real(4) :: xcent
character(len=1) :: phixy
real(4) :: zzss
integer(4) :: nchar
real(4) :: h
character(len=1) :: hv
integer(4) :: j
end function
END INTERFACE
INTERFACE
integer*2 function IGRK(c1in)
character(len=*) :: c1in
end function
END INTERFACE
INTERFACE
integer*2 function IGRKSC(c1in)
character(len=*) :: c1in
end function
END INTERFACE

END MODULE GraphFunctions