MODULE InitiateCoch

!use DFLIB
use IFQWIN
use IFCORE
use IFPORT
IMPLICIT NONE

SAVE


!! Graphic parameters for MATLAB interface !!!!!!!!!!!!!!!!!!1
real(8)            ::  DTplot		! dt for direct display	 1
integer(2)		   ::  nBMplot		! # BM points to diplay	 1
integer(2),dimension(10)::  iProbe	! probe point # at BM	 1
integer(2)		   ::  nProbe=0		! # filled elements in 	 1
									! iProbe (> computed)	 1
integer(2)		   ::  nPlotLoop	! # DTplot points /		 1
									! computation cycle		 1
real(8)            ::  DTs			! 1/f_sample			 1
integer(4)		   ::  nup			! upsample factor, DTs/dt2
character(len=32)  ::  data_file	! filename				 1
integer(4), allocatable:: stim_loc(:)! stores DTp/DTs points 1
									!   from data_file       1
real(8), allocatable:: Fs(:)		! stim-> upsample > dt   2
character(len=32)  ::  probe_file	! filename				 1
logical(1)		   ::  l_velocity	! T > probe V, F>probe Y 1
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1

!i/o params
integer(4), parameter  :: f_in1=2
integer(4), parameter  :: f_in2=15
integer(4), parameter  :: f_in3=16
integer(4), parameter  :: f_in4=17
integer(4), parameter  :: f_out1=18
integer(4), parameter  :: f_out2=19
integer(4), parameter  :: f_out3=20
integer(4), parameter  :: f_out4=21
integer(4), parameter  :: f_out5=22
integer(4), dimension(100) :: stimulus
common /STIM/ stimulus

!====
!Fortran
integer(4), parameter  :: nBM = 400
integer(4), parameter  :: nBM1 = nBM+1
integer(4)             :: nTimeSlice = 10 !default
!Interaction C
integer(4)  :: pBM         =nBM1
integer(4)  :: pTimeSlice  
common /NPTS/ pBM,pTimeSlice
equivalence (nTimeSlice,pTimeSlice)

!Logicals
logical(1) :: l_init,   l_store	
logical(1) :: l_coupler
logical(1) :: l_test, l_apex_shortcut
logical(1) :: l_screenplot, l_out

!Declaration of integer parameters.

integer(4), parameter :: npar1=400
integer(1)            :: FREQUENCY_MAP
integer(1), parameter :: $STRAIGHT=0
integer(1), parameter :: $GREENWOOD=1
integer(1)            :: DAMPING_PROFILE
integer(1), parameter :: $CONSTANT_Q=0
integer(1), parameter :: $Q_SQRT_F=1
integer(1), parameter :: $LOW_Q=2
integer(1)            :: num_sec_tot 
integer(4)			  :: FunctionKind
integer(4), parameter :: ik2 = int(selected_int_kind(4)/2) 	
integer(4), parameter :: ik4 = int(selected_int_kind(9)/2) 	
integer(4), parameter :: sng = int(kind(1.e0))
integer(4), parameter :: dbl = int(kind(1.d0))

!Declaration of real(8) parameters.

real(8), parameter :: PI_D=3.141592653589793238462644d0
real(8), parameter :: par1=1.d0
real(8), parameter :: par2=2.d0
real(8), parameter :: parh=0.5d0
real(8), parameter :: parh6=0.166666666666666666666666667d0
real(8)            :: dt             !=1.d-6   !2.5d-6    
real(8), parameter :: xl_BM=35.d-3   !m

real(8), parameter :: b_Scala=1.d-3	!m
real(8), parameter :: h_Scala=1.d-3	!m
real(8), parameter :: rho=1.d+3		!kg/m3
real(8), parameter :: S_ST= 3.d-6    !m2
real(8), parameter :: S_TM=60.d-6    !m2
real(8), parameter :: f_ME= 2.d+3    !Hz
real(8), parameter :: Q_ME=0.4d0     !
real(8), parameter :: Zsa=415.d0     !Pa s/m
real(8), parameter :: Zaa=Zsa/S_TM

real(8), parameter :: d_cp= 140.d5	!Ns/m5 =kg/sm4= Pa/(m/s)
real(8), parameter :: m_cp= 43.4d2	!kg/m4
real(8), parameter :: s_cp= 1./2.28d-11  !kg/s2m4

real(8), parameter :: p0    = 2.d-5  !Pa
real(8), parameter :: eps   = 5.d-2  !1/Q slakkehuis 
real(8), parameter :: eps2  = 2.d0   !low Q-value 
real(8)            :: epsf           !used for final value

!Declaration of arrays.

real(8), dimension(0:npar1) :: s,d !eventueel npar1
real(8), dimension(1:npar1) :: alpha, beta, gamma
real(8), dimension(1:npar1) :: d_factor

integer(4) :: n

real(8), allocatable :: Y(:,:),V(:,:) 
real(8), allocatable :: M(:,:)
real(8), allocatable :: g(:)	
real(8), allocatable :: q(:)	
real(8), allocatable :: b(:),bnew(:)
real(8), allocatable :: k(:)

!Declaration of variables.

!1) Integers.

integer(4) :: kmax, k_RK4, kkRK4, i, irl
integer(4) :: kk
integer(1) :: NonLin 

!2) Reals.

real(8) :: dt2 ,dt6, t0, T_max
real(8) :: dx,xrel_ow_1,d_ow_1
real(8) :: w_ME,ms_ME,ds_ME,ss_ME,r_Xtr0,nt_ME
real(8) :: S_Scala,b_BM,ma_BM,ma_F01,ma_F	
real(8) :: ms_BM, ss0BM	
real(8) :: m0_RK4,AxA,gam0,alf0	
real(8) :: p_stim,p_probe,p0x	
real(8) :: pEC                    !,pECmax			
real(8) :: E1,E2,ES1,s00,s000	
real(8) :: A2,AME,ASC,ASC01,AHT	
real(8) :: F0				
real(8) :: Vsom
real(8) :: L_stim,L_probe		
real(8) :: StimulusPeriod,ProbePeriod		
real(8) :: BM_impedance_factor	
real(8) :: q0_factor				
real(8) :: g0r_factor			
real(8) :: Y01_factor			
real(8) :: stim_onset_duration 
real(8) :: s_r_factor, s_x_factor, x_0

real(8) :: KHTfactor
real(8) :: T_d, t0_d
real(4) :: T_s, t0_s
real(8) :: U_apex_t
     

END MODULE InitiateCoch

!===============================================================
MODULE InitiateOae99

use DFLIB
IMPLICIT NONE

SAVE

!Declaration of variables.

!1) Integers.

integer(1) :: n_section=0
integer(4) :: num_pps

!2) Reals.

real(8) :: T_section
real(8), parameter :: T_sect_default = 80.d-3 !100 ms
real(8) :: probe1_begin,  probe1_end
real(8) :: probe2_begin,  probe2_end
real(8) :: probe_onset_duration
real(8) :: probe_offset_duration
real(8) :: probe_duration


END MODULE InitiateOae99

!===============================================================

MODULE CochFunctions
SAVE
INTERFACE F
    FUNCTION F_double ( t0, T )
	real(8) :: t0, T, F_double
	END FUNCTION F_double
	FUNCTION F_single ( t0, T )
	real(4) :: t0, T, F_single
	END FUNCTION F_single
!	FUNCTION F_int4   ( t0, T )
!	integer(4) :: F_int4, t0, T
!	END FUNCTION F_int4
!	FUNCTION F_int2   ( t0, T )
!	integer(2) :: F_int2, t0, T
!	END FUNCTION F_int2
	FUNCTION Fi_double ( it0, iT )
	real(8) :: Fi_double
	integer(4) :: it0, iT
	END FUNCTION Fi_double
END INTERFACE
INTERFACE 
	function GG (v_i, y_i, icnt)
	real(8) :: GG, v_i, y_i
	integer(4) :: icnt
	end function GG
END INTERFACE
END MODULE CochFunctions


!===============================================================

