! Creates and positions legend, membrane, stimulus and/or cochleagram - window

SUBROUTINE CreateWindows
	USE Declare
	USE WindowsModule
	USE GraphsModule
	USE DFLIB
	IMPLICIT NONE
	TYPE (qwinfo)  winfo
  	INTEGER spaceBar /0/
  	integer(4) :: GETWSIZEQQresult

	GETWSIZEQQresult = GETWSIZEQQ (QWIN$FRAMEWINDOW, QWIN$SIZEMAX, winfo)

	legend_width = -1
	upper_graphs_height = -2
	stimulus_graph_height = -2
	IF (plotLegend) THEN
		legend_width = 35
		upper_graphs_height = 12
		CALL CreateWindow (LEGEND_UNIT, legend_width*8, upper_graphs_height*16, LEGEND_TITLE)
		CALL PositionWindow (LEGEND_UNIT, 0, 0, legend_width, upper_graphs_height)
	ENDIF

	IF (plotMembrane) THEN
		upper_graphs_height = 12
		CALL CreateWindow (MEMBRANE_UNIT, n_plotpoints, upper_graphs_height*16, MEMBRANE_TITLE)
		CALL PositionWindow (MEMBRANE_UNIT, legend_width+1, 0, -1, upper_graphs_height)
	ENDIF

	! make vertical space for horizontal space bar if necessary
	IF (t_plotpoints>winfo.w) spaceBar = 21

	IF (plotStimulus) THEN
		stimulus_graph_height = 12
		CALL CreateWindow (STIMULUS_UNIT, t_plotpoints, stimulus_graph_height*16 + spaceBar, STIMULUS_TITLE)
		CALL PositionWindow (STIMULUS_UNIT, 0, upper_graphs_height + 2, -1, stimulus_graph_height + spaceBar / 16)
	ENDIF

	IF (plotCochleagram) THEN
		CALL CreateWindow (COCHLEAGRAM_UNIT, t_plotpoints, n_plotpoints + spaceBar, COCHLEAGRAM_TITLE)
		CALL PositionWindow (COCHLEAGRAM_UNIT, 0, upper_graphs_height + stimulus_graph_height + 4, -1, -1)
	ENDIF

END SUBROUTINE CreateWindows
