! Positions window with <UNITnr> to horizontal pixel <x> and veritcal pixel <y>
! and defines the <width> and <height> of the window in colums and rows

SUBROUTINE PositionWindow(UNITnr, x, y, width, height)
	USE DFLIB
	IMPLICIT NONE
	INTEGER, INTENT(IN) :: UNITnr
	INTEGER, INTENT(IN) :: x
	INTEGER, INTENT(IN) :: y
	INTEGER, INTENT(IN) :: width
	INTEGER, INTENT(IN) :: height
	INTEGER(2) FrameWidth
	INTEGER(2) FrameHeight
	integer(4) :: getWsizeQQresult, setWsizeQQresult
	TYPE (qwinfo) wInfo

	getWsizeQQresult = GETWSIZEQQ (QWIN$FRAMEWINDOW, QWIN$SIZEMAX, wInfo)
	FrameWidth = wInfo.w
	FrameHeight = wInfo.h
	getWsizeQQresult = GETWSIZEQQ (UNITnr, QWIN$SIZEMAX, wInfo)
	winfo.x = INT2(x)
	winfo.y = INT2(y)
	IF (width>0) THEN
		winfo.w = INT2(width)
	ELSE
		winfo.w = (FrameWidth - INT2(16))/INT2(8) - winfo.x - 1
	ENDIF
	IF (height>0) THEN
		winfo.h = INT2(height)
	ELSE
		winfo.h = (FrameHeight - INT2(72))/INT2(16) - winfo.y - 1
	ENDIF
	setWsizeQQresult = SETWSIZEQQ (UNITnr, winfo)

END SUBROUTINE