! Plots a new line in the COCHLEAGRAM_UNIT
! Color of plotting, indicating the value (velocity or displacement)
! is determined by a call to the function ColorMap.
! Color is dependant on the value on the linear scale
! <MinimumPositionToPlot> to <MaximumPositionToPlot>

SUBROUTINE PlotCochleagramLine

	USE Declare
	USE GraphsModule
	USE WindowsModule
	USE IFQWIN
	IMPLICIT NONE
	INTEGER colormap
!	REAL(8) stimulus
	INTEGER(2) horizontal_pixel(0:n_plotpoints-1)
	INTEGER color(0:n_plotpoints-1)
	integer(4) :: setActiveQQresult

	! determine the color for all the points to plot, scaled linearly between <MinimumPositionToPlot> and <MaximumPositionToPlot>
	IF (plotPositions) THEN
		DO i = 0, n_plotpoints - 1
			color(i) = colormap (positionMatrix(i, t_plotCounter), minimumPositionToPlot, maximumPositionToPlot)			
		END DO
	ELSE
		DO i = 0, n_plotpoints - 1
			color(i) = colormap (velocityMatrix(i, t_plotCounter), minimumVelocityToPlot, maximumVelocityToPlot)			
		END DO
	ENDIF

	setActiveQQresult = SETACTIVEQQ (COCHLEAGRAM_UNIT) 
	horizontal_pixel = t_plotCounter

	! Plot the cochleagram line
	CALL SETPIXELSRGB (n_plotpoints, horizontal_pixel, section_axis, color) 

END SUBROUTINE PlotCochleagramLine