SUBROUTINE PlotGraphs
	USE SampleDownModule
	USE Declare
	USE GraphsModule
	USE WindowsModule
	USE ParametersModule, ONLY: plotPhase
	USE IFQWIN
	IMPLICIT NONE
!	REAL(8) stimulus
	INTEGER ii
	REAL SampleDown
	integer(4) :: SETACTIVEQQresult 
	integer(4) :: SETPIXELRGBresult


	IF (plotMembrane .or. plotCochleagram .or. plotPhase) THEN
	  IF (preventAliasing) THEN
		LastPositionPoints (:, LastIndex) = REAL(Y(1:n:plotEvery_n_points))
		LastVelocityPoints (:, LastIndex) = REAL(V(1:n:plotEvery_n_points))
		LastIndex = LastIndex +1
		!circular buffer
		IF (LastIndex  > 2*windowBoundary) LastIndex = 0

		IF (kk>=windowBoundary .AND. MOD(kk-windowBoundary, plotEvery_t_points) == 0) THEN
			t_plotCounter = t_plotCounter +1
			DO ii = 0, n_plotpoints-1
				positionMatrix(ii, t_plotcounter) = SampleDown (LastPositionPoints(ii, :), LastIndex)
				velocityMatrix(ii, t_plotcounter) = SampleDown (LastVelocityPoints(ii, :), LastIndex)
			ENDDO
			velocityStapes(t_plotCounter) = REAL(V(0))
			positionStapes(t_plotCounter) = REAL(Y(0))
			IF (plotMembrane)    CALL PlotMembraneGraph
			IF (plotCochleagram) CALL PlotCochleagramLine
		ENDIF
	  ELSE
		IF (MOD(kk, plotEvery_t_points) == 0) THEN
			t_plotCounter = t_plotCounter +1
			! store current velocities and position of sections 1:n with an interval of plotEvery_n_points in velocityMatrix and positionMatrix
			velocityMatrix(section_axis, t_plotCounter) = REAL(V(1:n:plotEvery_n_points))
			positionMatrix(section_axis, t_plotCounter) = REAL(Y(1:n:plotEvery_n_points))
			velocityStapes(t_plotCounter) = REAL(V(0))
			positionStapes(t_plotCounter) = REAL(Y(0))
			IF (plotMembrane)    CALL PlotMembraneGraph
			IF (plotCochleagram) CALL PlotCochleagramLine
		ENDIF
	  ENDIF
	ENDIF

	IF (plotStimulus) THEN
		SETACTIVEQQresult = SETACTIVEQQ (STIMULUS_UNIT) 
		SETPIXELRGBresult = SETPIXELRGB(t_plotCounter,  INT2((-stimulus0/maximumSignalPressure + 1) * stimulus_graph_height * 16 / 2), #FFFFFF)
	ENDIF

END SUBROUTINE PlotGraphs
