SUBROUTINE PlotProfileGraph

	USE Declare
	USE GraphsModule
	USE WindowsModule
	USE IFQWIN
	IMPLICIT NONE
	REAL(8) levelToDecibel
	INTEGER maximum_dB
	INTEGER minimum_dB
	integer(4) :: SetActiveQQResult
	REAL(8) profile_dB
	CHARACTER(12) IntToString
	TYPE (rccoord) curpos
	INTEGER(2) vertical_pixel (0: n_plotpoints-1)

	IF (plotProfile) THEN
		upper_graphs_height = 12
		CALL CreateWindow (PROFILE_UNIT, n_plotpoints, upper_graphs_height*16, PROFILE_TITLE)
		IF (plotMembrane) THEN
!			CALL PositionWindow (PROFILE_UNIT, 3*(legend_width+1), upper_graphs_height + 2, -1, upper_graphs_height)
			CALL PositionWindow (PROFILE_UNIT, int(2.5*legend_width)+1, 0, -1, upper_graphs_height)
		ELSE
			CALL PositionWindow (PROFILE_UNIT, legend_width+1, 0, -1, upper_graphs_height)
		ENDIF

		SetActiveQQResult = SETACTIVEQQ (PROFILE_UNIT) 

		IF (plotPositions) THEN
			maximumPosition = MAXVAL(positionMatrix)
			maximum_dB =  CEILING(LevelToDecibel (DBLE(maximumPosition), 1d-9) / 10) * 10
			minimum_dB = maximum_dB - 60	! reach is 60 dB = factor 1000
			DO i=0, n_plotpoints - 1
				profile_dB = LevelToDecibel (DBLE(MAXVAL(positionMatrix(i, :))), 1d-9)
				vertical_pixel(i) = (- (profile_dB - minimum_dB) / (maximum_dB - minimum_dB) + 1) * (upper_graphs_height * 16 -1)
			ENDDO
		ELSE
			maximumVelocity = MAXVAL(velocityMatrix)
			maximum_dB =  CEILING(LevelToDecibel (DBLE(maximumVelocity), 1d-9) / 10) * 10
			minimum_dB = maximum_dB - 60	! reach is 60 dB = factor 1000
			DO i=0, n_plotpoints - 1
				profile_dB = LevelToDecibel (DBLE(MAXVAL(velocityMatrix(i, :))), 1d-9)
				vertical_pixel(i) = (- (profile_dB - minimum_dB) / (maximum_dB - minimum_dB) + 1) * (upper_graphs_height * 16 -1)
			ENDDO
		ENDIF
		CALL SETPIXELSRGB (n_plotpoints, section_axis, vertical_pixel, white) 

		CALL SETTEXTPOSITION (INT2(0), INT2(0), curpos)
		WRITE (PROFILE_UNIT, *) TRIM(IntToString(maximum_dB)) // " dB"
		CALL SETTEXTPOSITION (INT2(upper_graphs_height), INT2(0), curpos)
		WRITE (PROFILE_UNIT, '($A7)') TRIM(IntToString(minimum_dB)) // " dB"

	ENDIF

END SUBROUTINE PlotProfileGraph
