SUBROUTINE Initialize
	USE Declare
	IMPLICIT NONE

	ALLOCATE (	sdivm(0:n), &
				ddivm(0:n), &
				ddivmvdP(0:n), &
				x(0:n), &
				Y(0:n), &
				V(0:n), &
				Ytmp(0:n), &
				Vtmp(0:n), &
!				M1234(4,0:n), &
!				M2(0:n), &
!				M3(0:n), &
!				M4(0:n), &
				g(0:n), &
				q(0:n), &
				b(0:n), &
				k(0:n), &
						STAT = err)

	IF (err /= 0) CALL AllocationError

	dt = 1d0 / ComputationalFrequency
	half_dt = dt / 2d0
	kmax = INT(t_max / dt)
	t_LastPeriod = t_max - 1d0/signal1Frequency

	CALL InitializeFiles
	CALL InitializeStimulus
	CALL InitializeCochlea
	CALL InitializeMiddleEar
	CALL SetDampingAndStiffness 
	CALL InitializeZweig
	CALL InitializeGaussElimination

END SUBROUTINE Initialize
