SUBROUTINE InitializeMiddleEar
	USE Declare
	IMPLICIT NONE

	REAL(8) w_ME
	REAL(8) stapes_area
	REAL(8) nt
	REAL(8) AcousticImpedanceOfAir

	stapes_area = stapesArea(parameterSet)
	nt = MiddleEarTransformer(parameterSet)
	AcousticImpedanceOfAir = SpecificAcousticImpedanceOfAir / eardrumArea(parameterSet)
	w_ME = 2 * pi * MiddleEarResonanceFrequency(parameterSet)

	IF (useEarCanalCoupler) THEN
		ds_ME = nt ** 2 * damping_coupler(parameterSet) * stapes_area
		ms_ME = MiddleEarQualityFactor * ds_ME / w_ME
		ss_ME = ms_ME * w_ME ** 2
		m0_RK4=bm_mass/(ms_ME + nt ** 2 * mass_coupler(parameterSet) * stapes_area)
		gam0 = bm_mass/(bm_width*dx)/((ms_ME/stapes_area)+(nt ** 2 * mass_coupler(parameterSet)))
		r_Xtr0=(nt ** 2 * stapes_area * stiffness_coupler)/bm_mass
	ELSE
		!specifiic acoustic values:
		ds_ME = nt ** 2 * AcousticImpedanceOfAir * stapes_area
		ms_ME = MiddleEarQualityFactor * ds_ME / w_ME
		ss_ME = ms_ME * w_ME ** 2
		m0_RK4 = bm_mass / ms_ME
		gam0 = (stapes_area * bm_mass/(bm_width*dx))/ms_ME
		r_Xtr0 = 0
	ENDIF

	g0_factor = ms_ME * m0_RK4 / nt
	q0_factor = (bm_mass - ms_ME * m0_RK4) / nt
	Y0_factor = ss_ME / nt
	d_m_factor = ds_ME / bm_mass
	s_m_factor = ss_ME / bm_mass
	p0x = nt / bm_mass

END SUBROUTINE InitializeMiddleEar