!This function is used by "cochlea" and "cochleaDialog"

!converts <r> to a string without useless zeros's in the decimal part or in the exponent
!uses Scientific Notation, but numbers between 0.1 and 1000 will be printed completely
!example: 1.23400000000000d+001 --> "12.34"
!example: 0.001234 --> "1.234E-3"
!precision must be greater than 0.

FUNCTION RealToString (r, precision)

	IMPLICIT NONE
	CHARACTER(22) RealToString, strng
	REAL(8), INTENT (IN) :: r
	INTEGER, INTENT (IN) :: precision
	INTEGER exp	! exp points to first exponent-digit in string
	INTEGER dec ! dec points to last decimal digit in string
	INTEGER i
	
	exp = 20
	dec = 17
	WRITE (strng, '(ES22.14E3)') r
	!e.g. strng=" 1.23400000000000E+000", NOTE the space in front
	!e.g. strng="-1.23456000000000E-001"
	
	DO i = 4+precision, dec
		strng(i:i) = "0"
	ENDDO
		
	IF (strng(exp:exp)=="0") THEN
		strng=strng(1:exp-1) // strng(exp+1:)	! remove first exponent zero
		IF (strng(exp:exp)=="0") THEN
			strng=strng(1:exp-1) // strng(exp+1:)	! remove second exponent zero also
			IF (strng(exp:exp)=="0") THEN
				strng=strng(1:dec)	!remove whole exponent-part
			ELSE	!Exponent contains only one digit, e.g. "E+2"
				SELECT CASE (strng(exp-1:exp))
				CASE ("-1")
					strng = strng(1:1) // "0." // strng(2:2) // strng(4:dec)
					dec=dec+1
				CASE ("+1")
					strng = strng(1:2) // strng(4:4) // "." // strng(5:dec)
				CASE ("+2")
					strng = strng(1:2) // strng(4:5) // "." // strng(6:dec)
				CASE ("+3")
					strng = strng(1:2) // strng(4:6) // "." // strng(7:dec)
				ENDSELECT
			ENDIF
		ENDIF
	ENDIF
	DO WHILE (strng(dec:dec)=="0")	!remove usesless decimal zero's
		strng=strng(1:dec-1) // strng(dec+1:)
		dec=dec-1
	END DO

	IF (strng(dec:dec)==".") THEN	!remove usesless dot
		strng=strng(1:dec-1) !!// strng(dec+1:) dec was laatste karakter, dus?
	ENDIF

	IF (strng(1:1)==" ") THEN	!remove usesless space
		strng=strng(2:)
	ENDIF

	RealToString = strng

END FUNCTION RealToString