! displays rescale dialog box
! sets the current parameters to the fields in the box
! default settings are automatic scaling over the found dynamic range
! user set values are read after user pressed OK-button (that is "Rescale"-button)
! <output> is true if user pressed OK-button; false if user pressed Cancel button ("Finish")

SUBROUTINE ShowRescaleDialog (output)

	USE Declare
	USE GraphsModule
	USE DialogDeclare
	USE IFLOGM
	IMPLICIT NONE
	INCLUDE 'resource.fd'
	INCLUDE 'DialogInclude'
	EXTERNAL UpdateMinimumValue
	EXTERNAL UpdateMaximumValue
	EXTERNAL UpdateRadioButton
	EXTERNAL RadioButtons
	REAL(8) temp
	LOGICAL output
	INTEGER dlgoutput
	INTEGER ios
	CHARACTER(100) string

	ok = DLGINIT (DIALOG_Rescale, dlg)
    IF (.not. ok)  WRITE (*,*) 'ERROR: dialog not found'

	! Minimum Velocity / Position
	ok = DLGSETSUB (dlg, RADIO_setSmallestAsMin, UpdateMinimumValue)
	ok = DLGSETSUB (dlg, RADIO_setCurrentAsMin, UpdateMinimumValue)
	ok = DLGSETSUB (dlg, RADIO_setNewAsMin, UpdateMinimumValue)
	ok = DLGSETSUB (dlg, EDIT_NewMinimumValue, UpdateRadioButton)


	! Maximum Velocity / Position
	ok = DLGSETSUB (dlg, RADIO_setLargestAsMax, UpdateMaximumValue)
	ok = DLGSETSUB (dlg, RADIO_setCurrentAsMax, UpdateMaximumValue)
	ok = DLGSETSUB (dlg, RADIO_setNewAsMax, UpdateMaximumValue)
	ok = DLGSETSUB (dlg, EDIT_NewMaximumValue, UpdateRadioButton)

	! Select graphs
	ok = DLGSETLOG (dlg, CHECK_PlotLegend, plotLegend)
	ok = DLGSETLOG (dlg, CHECK_PlotMembrane, plotMembrane)
	ok = DLGSETLOG (dlg, CHECK_PlotCochleagram, plotCochleagram)
	ok = DLGSETLOG (dlg, CHECK_PlotProfile, plotProfile)

	! Plot positions or velocities
	ok = DLGSETLOG (dlg, RADIO_plotPositions, plotPositions)
	ok = DLGSETSUB (dlg, RADIO_plotPositions, RadioButtons)
	ok = DLGSETLOG (dlg, RADIO_PlotVelocities, .NOT. plotPositions)
	ok = DLGSETSUB (dlg, RADIO_PlotVelocities, RadioButtons)
	CALL RadioButtons (dlg, RADIO_plotPositions, 0)

	dlgoutput = DLGMODAL (dlg)
	output = (dlgoutput == IDOK)

	IF (output) THEN		! that is the "Rescale"-button
		DialogErrorMessage = ""

		ok = DLGGETLOG (dlg, RADIO_plotPositions, plotPositions)

		IF (plotPositions) THEN
			minimumPositionToPlot = SNGL (GetRealFromDialog (dlg, EDIT_NewMinimumValue)/1d9)
			maximumPositionToPlot = SNGL (GetRealFromDialog (dlg, EDIT_NewMaximumValue)/1d9)
		ELSE
			minimumVelocityToPlot = SNGL (GetRealFromDialog (dlg, EDIT_NewMinimumValue)/1d6)
			maximumVelocityToPlot = SNGL (GetRealFromDialog (dlg, EDIT_NewMaximumValue)/1d6)
		ENDIF
		ok = DLGGETLOG (dlg, CHECK_plotLegend, plotLegend)
		ok = DLGGETLOG (dlg, CHECK_plotMembrane, plotMembrane)
		ok = DLGGETLOG (dlg, CHECK_plotCochleagram, plotCochleagram)
		ok = DLGGETLOG (dlg, CHECK_plotProfile, plotProfile)
	ENDIF

	CALL DLGUNINIT (dlg)

END SUBROUTINE ShowRescaleDialog