! Reads FMT-header of wave file with file handler <handler>
! If errors in FMT-header are found, <WaveFileErrorMessage> is set

SUBROUTINE ReadFmtChunk (handler)
	USE WaveReadModule
	USE winmm
	IMPLICIT NONE
	INTEGER handler
	EXTERNAL GetShort, GetUnsignedShort, GetLong !, GetSignedBytes
	!INTEGER GetSignedBytes
	INTEGER(2) GetShort
	INTEGER(4) GetUnsignedShort
	INTEGER(4) GetLong
	INTEGER BitsPerSample

	IF (WaveFileErrorMessage == "") THEN
		!Find FMT chunk
		SubChunk.ckid = mmioStringToFOURCC('fmt 'C, 0) 
		IF (mmioDescend(handler, SubChunk, WaveChunk, MMIO_FINDCHUNK) /= MMSYSERR_NOERROR) THEN	!FMT chunk not found
			WaveFileErrorMessage = CORRUPTWAVEFILE
		ELSEIF (SubChunk.cksize /= 16) THEN
			WaveFileErrorMessage = COMPRESSEDWAVEFILE
		ELSE	! found FMT chunk of the right size

			!Read FMT chunk
			FormatTag = GetShort (handler)
			Channels = GetUnsignedShort (handler)
			SamplesPerSec = GetLong (handler)	!NOTE: Actually SamplesPerSec is an unsigned long, but for values below 2^31 this works fine 
			AvgBytesPerSec =  GetLong (handler)	!NOTE: Actually AvgBytesPerSec is an unsigned long, but for values below 2^31 this works fine 
			BlockAlign = GetUnsignedShort (handler)
			BitsPerSample = GetUnsignedShort (handler)

			IF (MOD (BitsPerSample, 8) /= 0) THEN
				WaveFileErrorMessage = WRONGNUMBEROFBITSPERSAMPLE
			ELSE
				BytesPerSample = BitsPerSample / 8
				!Step out FMT chunk
				IF (mmioAscend (handler, subChunk, 0) /= MMSYSERR_NOERROR ) THEN
					WaveFileErrorMessage = CORRUPTWAVEFILE
				ENDIF
			ENDIF
		ENDIF
	ENDIF
END SUBROUTINE ReadFmtChunk