SUBROUTINE ErrorHandling
	USE Declare
	USE DialogDeclare
	USE WaveReadModule
	USE IFLOGM
!	USE IFQWIN
	USE USER32
	IMPLICIT NONE
	EXTERNAL GetTabNumber
	INTEGER GotoTab, SelectedTab, GetTabNumber
	integer(4) :: ifunc

	IF (n<1) THEN
		DialogErrorMessage = "The number of sections must be positive"C
		ErrorDLG = dlg_tab1
		ErrorID = EDIT_n
	ENDIF

	IF (ComputationalFrequency < 1) THEN
		DialogErrorMessage = "The internal computation frequency must be positive"C
		ErrorDLG = dlg_tab1
		ErrorID = EDIT_ComputationalFrequency
	ENDIF

	IF (signal3Duration < (1 / ComputationalFrequency)) THEN
		DialogErrorMessage = "The pulse duration must be larger than the internal computation time step"C
		ErrorDLG = dlg_tab2
		ErrorID = EDIT_signal3Duration
	ENDIF

	IF (signal3Period < signal3Duration) THEN
		DialogErrorMessage = "The pulse period must be larger than or equal to the pulse duration"C
		ErrorDLG = dlg_tab2
		ErrorID = EDIT_signal3Period
	ENDIF

	IF (ConstantQ == 0) THEN
		DialogErrorMessage = "The quality factor, Q, may not be zero"C
		ErrorDLG = dlg_tab4
		ErrorID = EDIT_ConstantQ
	ENDIF

	IF (plotPositions) THEN
		IF (minimumPositionToPlot >= maximumPositionToPlot) THEN
			DialogErrorMessage = "The maximum position must be greater than the minimum position"C
			ErrorDLG = dlg_tab5
			ErrorID = EDIT_maximumValueToPlot
		ENDIF
	ELSE
		IF (minimumVelocityToPlot >= maximumVelocityToPlot) THEN
			DialogErrorMessage = "The maximum velocity must be greater than the minimum velocity"C
			ErrorDLG = dlg_tab5
			ErrorID = EDIT_maximumValueToPlot
		ENDIF
	ENDIF

	IF (WaveFileErrorMessage /="" .AND. useAudioFile) THEN
		DialogErrorMessage = WaveFileErrorMessage
		ErrorDLG = dlg_tab3
		ErrorID = BUTTON_openAudioFile
	ENDIF

	IF (.NOT. (useAudioFile .OR. useSignal1 .OR. useSignal2 .OR. useSignal3 .OR. retrieveMembraneStatus) ) THEN
		DialogErrorMessage = "No stimulus present.\nSelect a stimulus or use stored initial values."C
		ErrorDLG = dlg_tab2
		ErrorID = RADIO_composeStimulus
	ENDIF

	IF ((storePressureEarCanal .OR. storeProfile .OR. storeProbing) .AND. SCAN(OutputDirectory, "*?""<>|") /=0) THEN
		DialogErrorMessage = "A directory name may not contain any of the\nfollowing characters: * ? "" < > |"C
		ErrorDLG = dlg_tab6
		ErrorID = EDIT_outputDirectory
	ENDIF

	IF (storePressureEarCanal .AND. SCAN(PressureEarCanalFileName, "\/:*?""<>|") /=0) THEN
		DialogErrorMessage = "A file name may not contain any of the\nfollowing characters: \\ / : * ? "" < > |"C
		ErrorDLG = dlg_tab6
		ErrorID = EDIT_pressureEarCanalFileName
	ENDIF

	IF (storeProfile .AND. SCAN(ProfileFileName, "\/:*?""<>|") /=0) THEN
		DialogErrorMessage = "A file name may not contain any of the\nfollowing characters: \\ / : * ? "" < > |"C
		ErrorDLG = dlg_tab6
		ErrorID = EDIT_profileFileName
	ENDIF

	IF (storeProbing .AND. SCAN(ProbingFileName, "\/:*?""<>|") /=0) THEN
		DialogErrorMessage = "A file name may not contain any of the\nfollowing characters: \\ / : * ? "" < > |"C
		ErrorDLG = dlg_tab6
		ErrorID = EDIT_probingFileName
	ENDIF



	IF (DialogErrorMessage == "") THEN
		g_OKpressed = .TRUE.
		CALL DLGEXIT(dlg_main)
		CALL PostQuitMessage(0)
	ELSE
		ifunc = MESSAGEBOX(dlg_main%hwnd, trim(DialogErrorMessage), "Wrong input"C, MB_OK  .OR. MB_ICONEXCLAMATION)
!		ifunc = MESSAGEBOXQQ(trim(DialogErrorMessage), "Wrong input"C, MB_OK  .OR. MB_ICONEXCLAMATION)

		!Select TAB containing control with wrong input
		ifunc = DLGGETINT(dlg_main, ID_TAB, SelectedTab, DLG_STATE)
		GotoTab = GetTabNumber (ErrorDLG)
		IF (.NOT. GotoTab == SelectedTab) THEN		!Giving control to a tab that already has control fails
			ifunc = DLGSETINT(dlg_main, ID_TAB, GotoTab, dlg_state)
		ENDIF

		!Select control with wrong input
		i = GetDlgItem(ErrorDLG%hwnd, ErrorID)
		i = SetFocus(i)
		DialogErrorMessage = ""
	ENDIF

END SUBROUTINE ErrorHandling
