SUBROUTINE GetGraphValues (dlg)

	USE Declare
	USE DialogDeclare
	IMPLICIT NONE
	INCLUDE 'DialogInclude'

	! select graphs
	ok = DLGGETLOG (dlg, CHECK_plotLegend, plotLegend)
	ok = DLGGETLOG (dlg, CHECK_plotStimulus, plotStimulus)
	ok = DLGGETLOG (dlg, CHECK_plotMembrane, plotMembrane)
	ok = DLGGETLOG (dlg, CHECK_plotCochleagram, plotCochleagram)
	ok = DLGGETLOG (dlg, CHECK_plotProfile, plotProfile)

	! graph size
	plotEvery_n_points = GetIntegerFromDialog (dlg, EDIT_plotEvery_n_points)
	plotEvery_t_points = GetIntegerFromDialog (dlg, EDIT_plotEvery_t_points)
	ok = DLGGETLOG (dlg, CHECK_preventAliasing, preventAliasing)

	! plot options
	ok = DLGGETLOG (dlg, RADIO_plotPositions, plotPositions)

	! scale options
	IF (plotPositions) THEN
		minimumPositionToPlot = REAL(GetRealFromDialog (dlg, EDIT_minimumValueToPlot)/1d9)
		maximumPositionToPlot = REAL(GetRealFromDialog (dlg, EDIT_maximumValueToPlot)/1d9)
	ELSE
		minimumVelocityToPlot = REAL(GetRealFromDialog (dlg, EDIT_minimumValueToPlot)/1d6)
		maximumVelocityToPlot = REAL(GetRealFromDialog (dlg, EDIT_maximumValueToPlot)/1d6)
	ENDIF


END SUBROUTINE GetGraphValues