SUBROUTINE ShowWaveFileInfo (dlg)
! If show then set wavefiletext and enable play button
! else hide wavefiletext and disable checkbox and play button
	USE Declare
	USE DialogDeclare
	USE WaveReadModule
	USE DFLOGM
	IMPLICIT NONE
	TYPE (dialog) dlg
	LOGICAL noWaveFileError
	EXTERNAL IntToString
	CHARACTER(12) IntToString
	CHARACTER(40) info(5)
	INTEGER, PARAMETER :: length = 34
	EXTERNAL Shorten
	CHARACTER(length) Shorten

	noWaveFileError = (WaveFileErrorMessage == "")
	ok = DLGSETLOG (dlg, BUTTON_play, noWaveFileError, DLG_ENABLE)
	
	info(1) = "File Name: " // Shorten (AudioFileName, length)
	IF (noWaveFileError) THEN
		info(2) = "Total Time (ms): " // IntToString (INT(1000*audioFileTotalTime))
		info(3) = "Channels: " // IntToString (channels)
		info(4) = "Bits per sample: " // IntToString (BytesPerSample*8)
		info(5) = "Samples per second: "// IntToString (SamplesPerSec)
	ELSE
		info(2) = ""
		info(3) = "Wave file error: " // WaveFileErrorMessage
		info(4) = ""
		info(5) = ""
	ENDIF

	ok = DLGSETCHAR (dlg, TEXT_AudioFileName, info(1))
	ok = DLGSETCHAR (dlg, TEXT_AudioFileTotalTime, info(2))
	ok = DLGSETCHAR (dlg, TEXT_AudioFileChannels, info(3))
	ok = DLGSETCHAR (dlg, TEXT_AudioFileBitsPerSample, info(4))
	ok = DLGSETCHAR (dlg, TEXT_AudioFileSamplesPerSecond, info(5))

END SUBROUTINE