! Shows main dialog box and centers it on screen.
! Handles user input until a QuitMessage is posted.
! User input is handled by subroutines that  are called
! automatically when user changes a value or presses
! a button.
! <OKpressed> is true if and only if dialog box is exited
! by pressing OK-button (in this case the "Start"-button)

SUBROUTINE ShowDialog (OKpressed, param)
	USE DialogDeclare
	USE MessageModule
	USE USER32
	USE IFLOGM

	IMPLICIT NONE
	TYPE (T_MSG)mesg
	LOGICAL, INTENT (OUT) :: OKpressed
	INTEGER, INTENT (OUT) :: param
	LOGICAL ok
	integer(4) :: ifunc

	g_OKpressed = .FALSE.
	
	! show dialog box
	ok = DlgModeless(dlg_main)

	IF (.NOT. ok) THEN
		! dialog box can not be showed for some reason
		CALL Message (0, DIALOGBOXERROR)
		STOP
	ENDIF

	! centers dialog box
	CALL CenterDialog (dlg_main.hwnd)

	! read and process posted messages
	! loop is terminated when a QuitMessage is posted
	DO WHILE( GetMessage (mesg, NULL, 0, 0) ) 
		IF ( .NOT. DlgIsDlgMessage(mesg)) THEN
			ifunc = TranslateMessage( mesg )
			ifunc = DispatchMessage( mesg )
		END IF
	END DO

	OKpressed = g_OKpressed
	param = mesg.wParam
END SUBROUTINE ShowDialog