SUBROUTINE UpdateScaleOptions (dlg, id, event)
	USE Declare
	USE DialogDeclare
	IMPLICIT NONE
	INCLUDE 'DialogInclude'

	ok = DLGGETLOG (dlg, RADIO_plotPositions, plotPositions)

	IF (plotPositions) THEN
		ok = DLGSETCHAR (dlg, EDIT_minimumValueToPlot, RealToString (DBLE (minimumPositionToPlot) * 1d9, 3))
		ok = DLGSETCHAR (dlg, EDIT_maximumValueToPlot, RealToString (DBLE (maximumPositionToPlot) * 1d9, 3))
		ok = DLGSETCHAR (dlg, TEXT_MinimumValueToPlot, "Minimum displacement to plot (nm)")
		ok = DLGSETCHAR (dlg, TEXT_MaximumValueToPlot, "Maximum displacement to plot (nm)")
	ELSE
		ok = DLGSETCHAR (dlg, EDIT_minimumValueToPlot, RealToString (DBLE (minimumVelocityToPlot) * 1d6, 3))
		ok = DLGSETCHAR (dlg, EDIT_maximumValueToPlot, RealToString (DBLE (maximumVelocityToPlot) * 1d6, 3))
		ok = DLGSETCHAR (dlg, TEXT_MinimumValueToPlot, "Minimum velocity to plot (nm/ms)")
		ok = DLGSETCHAR (dlg, TEXT_MaximumValueToPlot, "Maximum velocity to plot (nm/ms)")
	ENDIF

END SUBROUTINE