! Finds wave chunk in file with file handler <handler>
! If wave chunk is not found, <WaveFileErrorMessage> is set

SUBROUTINE FindWaveChunk (handler)
	USE WaveReadModule
	USE winmm
	IMPLICIT NONE
	INTEGER handler
	TYPE (T_MMCKINFO), POINTER :: infoParent

	IF (WaveFileErrorMessage == "") THEN
		NULLIFY (infoParent)
		WaveChunk.fccType = mmioStringToFOURCC('WAVE'C, 0)
		IF (mmioDescend(handler, WaveChunk, infoParent, MMIO_FINDRIFF) /= MMSYSERR_NOERROR) &
			WaveFileErrorMessage = NOTAWAVEFILE
	ENDIF

END SUBROUTINE FindWaveChunk