! Reads data-section of wavefile specified by <handler>
! If <useLeftChannel> data of left channel, otherwise
! data of right channel is stored in global array <WaveData>
! Data is scaled so the maximum and minimum possible values
! would image on -1 and +1

SUBROUTINE ReadData (handler, useLeftChannel)
	USE WaveReadModule
	USE WINMM

	IMPLICIT NONE
	INTEGER, INTENT(IN) :: handler
	LOGICAL, INTENT(IN) :: useLeftChannel
	REAL GetSample, GetSampleResult
	REAL RightChannel
	REAL skip
	INTEGER i
	
	IF (WaveFileErrorMessage == "") THEN

		SamplesPerChannel = DataSize / Channels / BytesPerSample
		AudioFileTotalTime = REAL(SamplesPerChannel) / REAL(SamplesPerSec)

		!(Re)allocate array for audio storage
		ALLOCATE (WaveData (SamplesPerChannel))

		!Store samples in WaveData
		DO i = 1, SamplesPerChannel
				WaveData(i) = GetSample (BytesPerSample, handler)
				IF (Channels>1) THEN
					RightChannel = GetSample (BytesPerSample, handler)
					IF (.NOT. useLeftChannel) WaveData(i) = RightChannel 
					IF (Channels == 3) GetSampleResult = GetSample (BytesPerSample, handler)
					!!!gebeurt hier uberhaupt iets mee?
				ENDIF
		ENDDO

		!Rescale WaveData between [-1, +1)
		WaveData = WaveData / MaxSigned_n_Bytes (BytesPerSample)

	ENDIF

END SUBROUTINE ReadData