#################################################
#################################################
#								#
#                CHAPTER 10: 				#
#    Hierarchical Bayesian Models for the		#
#     	 Force of Infection			#
#								#
# last update: 26/08/2012				#
#################################################
#################################################

rm(list=ls(all=TRUE))
setwd("c:/book/chapter10")

##### DEFINE FUNCTIONS
pavit<- function(datai){
pai1<-pai2<-datai
N<- length(pai1)
for(i in 1:(N-1)){
	if (pai2[i] > pai2[i+1]){
     pool<-(pai1[i]+pai1[i+1])/2
     pai2[i:(i+1)]<- pool
     k<- i+1	
       for(j in (k-1):1){
       	if (pai2[j] >  pai2[k]){
	       pool.2<- sum(pai1[j:k])/length(pai1[j:k])
	       pai2[j:k]<- pool.2}   
}
}
}	
output<-list(pai1,pai2)
names(output)<-c("pai1","pai2")
return(output)
}	


##################################################
## Section 10.2: Exploratory Data Analysis       #
##								 #
##################################################

##### rubella ######

rrr<-list(
age=c(1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5,12.5,13.5,14.5,
      15.5,16.5,17.5,18.5,19.5,20.5,21.5,22.5,23.5,24.5,25.5,26.5,27.5,
      28.5,29.5,30.5,31.5,32.5,33.5,34.5,35.5,36.5,37.5,38.5,39.5,40.5,41.5,42.5,43.5,44.5),
posi=c(31,30,34,57,95,104,90,96,134,110,111,147,138,141,53,49,73,
       69,97,65,74,84,82,79,90,84,81,72,71,51,45,45,35,39,
       36,37,37,37,28,26,25,21,18,18),
ni=c(206,146,168,189,219,195,164,145,180,160,148,178,177,165,67,58,81,
     79,111,76,82,101,88,85,94,91,89,76,79,56,52,48,37,41,40,38,39,41,30,27,25,22,19,18),
     Nage=44)
Rub1<- data.frame(rrr$age,rrr$posi,rrr$ni-rrr$posi,rrr$ni)
names(Rub1)<-c("AGE","POS","NEG","NTOT")

###### mumps ######

mmm2 <- list(
age=c(1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5,12.5,13.5,14.5,
      15.5,16.5,17.5,18.5,19.5,20.5,21.5,22.5,23.5,24.5,25.5,26.5,27.5,
      28.5,29.5,30.5,31.5,32.5,33.5,34.5,35.5,36.5,37.5,38.5,39.5,40.5,41.5,42.5,43.5,44.5),
posi=c(56,48,137,195,290,255,236,211,271,276,259,301,296,345,112,112,142,
       186,202,156,155,200,166,165,179,171,175,147,137,114,117,99,95,80,
       77,65,63,69,46,61,55,42,37,39),
ni=c(407,292,332,368,421,330,294,258,312,304,282,321,313,366,116,121,148,
     196,211,159,160,204,170,170,180,178,179,150,147,120,122,104,95,82,
     78,67,65,72,47,62,56,43,37,40),
     Nage=44)
Mump1<- data.frame(mmm2$age,mmm2$posi,mmm2$ni-mmm2$posi,mmm2$ni)
names(Mump1)<-c("AGE","POS","NEG","NTOT")

######## 
source("chapter10_nonparametrics.r")

### FIGURE 10.1 (left panel)
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

### prevalence (rubella)
kkk.r<-kkk.r2
j<- rrr$age 
gi<- rrr$posi/rrr$ni
pai<- gi
ageii<- rrr$age 
xx<- pavit(pai)
xx1<-pavit(kkk.r$pi.values)
kkk.r.m<-kkk.r$hr.values
kkk.r.m[kkk.r$hr.values<0]<-0
plot(rrr$age,rrr$posi/rrr$ni,cex=0.01*rrr$ni,xlim=c(0,46),xlab="age",ylab="proportion of seropositive",
     ylim=c(0,1),lwd=1)
lines(j,xx$pai2,type="s",lty=1)
lines(kkk.r$grid,xx1$pai2,lty=5)

### force of infection (rubella)
Pai.1<-xx$pai2
haz.1<- c(0,diff(Pai.1))/(1-Pai.1)
haz.temp<- haz.1[!is.na(haz.1) & haz.1 != Inf]
age.temp<- ageii[!is.na(haz.1) & haz.1 != Inf]
fit.haz10<- ksmooth(age.temp,haz.temp,ker="normal",bandwidth=8,x.points=ageii)
lines(ageii,2*fit.haz10$y)
lines(kkk.r$grid,2*kkk.r.m,lty=5)
axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4)/2,cex=0.9)
mtext(side=4,"force of infection", las=3,line=1.4)


### FIGURE 10.1 (right panel)
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

### prevalence (mumps)
kkk.m<-kkk.m2
j<- mmm2$age 
gi<- mmm2$posi/mmm2$ni
pai<- gi
ageii<- mmm2$age 
xx<- pavit(pai)
xx1<-pavit(kkk.m$pi.values)
kkk.m.m<-kkk.m$hr.values
kkk.m.m[kkk.m$hr.values<0]<-0
plot(mmm2$age,mmm2$posi/mmm2$ni,cex=0.005*mmm2$ni,xlab="age",ylab="proportion of seropositive",
     ylim=c(0,1),lwd=1)
lines(j,xx$pai2,type="s",lty=1)
lines(kkk.m$grid,xx1$pai2,lty=5)

### force of infection (mumps)
Pai.1<-xx$pai2
haz.1<- c(0,diff(Pai.1))/(1-Pai.1)
haz.temp<- haz.1[!is.na(haz.1) & haz.1 != Inf]
age.temp<- ageii[!is.na(haz.1) & haz.1 != Inf]
fit.haz10<- ksmooth(age.temp,haz.temp,ker="normal",bandwidth=6.5,x.points=ageii)
lines(kkk.m$grid,kkk.m.m,lty=5)
lines(ageii,fit.haz10$y)
axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4),cex=0.9)
mtext(side=4,"force of infection", las=3,line=1.4)



###################################################
## Section 10.3: Hierarchical Bayesian Models     #
##		     for the Force of Infection       #
##								  #
## 10.3.6 Application to the Data			  #
###################################################

### FIGURE 10.2
### reading in output from WinBUGS 1.4
rubella1<-read.table("rubella1.txt")
mumps1<-read.table("mumps1.txt")

tru05<- rubella1$V1
tru05c<- rubella1$V2
tru05ll<- rubella1$V3
ftru05<- rubella1$V4
ftru05c<- rubella1$V5
ftru05ll<- rubella1$V6
trub<-rubella1$V11

### FIGURE 10.2 (left panel)
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

plot(rrr$age,rrr$posi/rrr$ni,xlim=c(0,46),cex=0.01*rrr$ni,xlab="age",ylab="proportion of seropositive",
     ylim=c(0,1),lwd=2)
lines(rrr$age,tru05,lty=1,lwd=2)
lines(rrr$age,tru05c,lty=4,lwd=2)
lines(rrr$age,tru05ll,lty=6,lwd=2)
#legend(10,0.4,c("Exponential (alpha3=0)","Exponential (alpha3 > 0)","log-logistics"),lty=c(1,4,6))

lines(c(rrr$age),2*c(ftru05),lwd=2)
lines(c(rrr$age),2*c(ftru05c),lty=4,lwd=2)
lines(c(rrr$age),2*c(ftru05ll),lty=6,lwd=2)

axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4)/2,cex=0.9)
mtext(side=4,"force of infection", las=3,line=1.4)


### FIGURE 10.2 (right panel)
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

tmu05<- mumps1$V1
tmu05c<- mumps1$V3
tmu05ll<- mumps1$V5
ftmu05<- mumps1$V2
ftmu05c<- mumps1$V4
ftmu05ll<- mumps1$V6
tmub<-mumps1$V9
foimub1<-mumps1$V10 

plot(mmm2$age,mmm2$posi/mmm2$ni,cex=0.005*mmm2$ni,xlim=c(0,46),xlab="age",ylab="proportion of seropositive",
     ylim=c(0,1),lwd=2)
lines(mmm2$age,tmu05,lty=1,lwd=2)
lines(mmm2$age,tmu05c,lty=4,lwd=2)
lines(mmm2$age,tmu05ll,lty=6,lwd=2)

lines(c(mmm2$age),c(ftmu05),lwd=2)
lines(c(mmm2$age),c(ftmu05c),lty=4,lwd=2)
lines(c(mmm2$age),c(ftmu05ll),lty=6,lwd=2)

axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4),cex=0.9)
mtext(side=4,"force of infection", las=3,line=1.4)


###################################################
## Section 10.4: Hierarchical Nonparametric Models#
##								  #
## 10.4.3 Application to the Data			  #
###################################################

### FIGURE 10.3

fubbb04<-read.table("fubbb04.txt")

ls()

tru05<- rubella1$V1
tru05c<- rubella1$V2
tru05ll<- rubella1$V3
ftru05<- rubella1$V4
ftru05c<- rubella1$V5
ftru05ll<- rubella1$V6
trub<-rubella1$V11


kkk.r.m<-kkk.r2$hr.values
kkk.r.m[kkk.r2$hr.values<0]<-0
xx<-pavit(kkk.r1$pi.value)

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

plot(rrr$age,rrr$posi/rrr$ni,cex=0.01*rrr$ni,xlim=c(0,46),xlab="age",ylab="proportion of seropositive",
     ylim=c(0,1),lwd=2)
lines(kkk.r$grid,xx$pai2,lty=4,type="l",lwd=2)
lines(rrr$age,tru05ll,lty=5,type="l",lwd=2)
lines(rrr$age,fubbb04$V1,lty=1,type="s",lwd=2)

lines(c(0,rrr$age),c(0,ftru05)*2,lwd=2)
for(i in 1:44){
	lines(c(rrr$age[i],rrr$age[i]),c(fubbb04$V5[i]*2,fubbb04$V6[i]*2),lty=1,lwd=5,col=32)
}
lines(mmm2$age,fubbb04$V4*2,lty=1,lwd=2)
lines(c(0,rrr$age),c(0,ftru05ll)*2,lty=4,lwd=2)
lines(kkk.r$grid,kkk.r.m*2,lty=5,lwd=2)

axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4)/2,cex=0.9)
mtext(side=4,"force of infection", las=3,line=1.4)



### FIGURE 10.4

mumps2<-read.table("mumps2.txt")
tmu05<- mumps1$V1
tmu05c<- mumps1$V3
tmu05ll<- mumps1$V5
ftmu05<- mumps1$V2
ftmu05c<- mumps1$V4
ftmu05ll<- mumps1$V6
tmub<-mumps1$V9
foimub1<-mumps1$V10 

## kkk.m.m the isotonic foi based om lp
kkk.r.m<-kkk.m2$hr.values
kkk.r.m[kkk.m2$hr.values<0]<-0
xx<-pavit(kkk.m2$pi.value)

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

plot(mmm2$age,mmm2$posi/mmm2$ni,cex=0.005*mmm2$ni,xlim=c(0,46),xlab="age",ylab="proportion of seropositive",
     ylim=c(0,1),lwd=2)
lines(c(0,mmm2$age),c(0,tmu05c),lty=4,lwd=2)
lines(kkk.r$grid,xx$pai2,lty=5,type="l",lwd=2)
lines(mmm2$age,tmub,lty=1,type="s",lwd=2)

lines(c(mmm2$age),c(ftmu05),lwd=2)
for(i in 1:44){
	lines(c(mmm2$age[i],mmm2$age[i]),c(mumps2$V4[i],mumps2$V6[i]),lty=1,lwd=4,col=32)
}
lines(c(mmm2$age),c(mumps2$V5),lty=1,lwd=2)
lines(c(0,mmm2$age),c(0,ftmu05c),lty=4,lwd=2)
lines(c(kkk.m$grid),c(kkk.r.m),lty=5,lwd=2)

axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4),cex=0.9)
mtext(side=4,"force of infection", las=3,line=1.4)

### FIGURE 10.5

bball<-read.table("bball.txt")

id1<-c(1,2,3,4)
id2<-c(5,6,7,8)
titi<-c("3.5","4.5","5.5","6.5")

layout(matrix(c(1,1,2,2,3,3,4,4), 2,4, byrow = TRUE))
par(lwd=2,las=1,cex.axis=1.1,cex.lab=1.1,mgp=c(3, 0.5, 0))

for(i in 1:4){
ll.1 <- density(bball[,id1[i]],n=100,window="gaussian",na.rm=T)
ll.2 <- density(bball[,id2[i]],n=100,window="gaussian",na.rm=T)
x.l<- min(c(ll.1$x,ll.2$x))
x.u<- max(c(ll.1$x,ll.2$x))
y.l<- min(c(ll.1$y,ll.2$y))
y.u<- max(c(ll.1$y,ll.2$y))

plot(ll.1$x,ll.1$y,type="l",xlab="force of infection",ylab="density",ylim=c(y.l,y.u),xlim=c(0.22,0.45))
lines(ll.2$x,ll.2$y,lty=4)
title(paste("Age=",titi[i]),cex=0.5)
}


### FIGURE 10.6 (left panel)

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

kkk.r.m<-kkk.r2$hr.values
kkk.r.m[kkk.r2$hr.values<0]<-0
line.ii<-c(2:7)
plot(kkk.r2$grid,kkk.r.m,
     xlim=c(0,47),xlab="age",ylab="force of infection",
      ylim=c(0,0.4),type="l",lwd=2)
indr<-c(9,11,13,15,17,19)+1
ef<-c(0.00,0.01,0.02,0.03,0.04,0.05,0.06)
for(i in 1:length(indr)){
	lines(rrr$age,rubella1[,indr[i]],lty=line.ii[i],lwd=2)
	text(46,rubella1[,indr[i]][44],paste(ef[i]),cex=0.7)
}

### FIGURE 10.6 (right panel)

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

kkk.r.m<-kkk.m2$hr.values
kkk.r.m[kkk.m2$hr.values<0]<-0
plot(kkk.m2$grid,kkk.r.m,
     xlim=c(0,47),xlab="age",ylab="force of infection",
      ylim=c(0,0.75),type="l",lwd=2)
indr<-c(7,9,11)+1
line.ii<-c(2,3,4)
for(i in 1:length(indr)){
	lines(mmm2$age,mumps1[,indr[i]],lty=line.ii[i],lwd=2)
	text(46,mumps1[,indr[i]][44],paste(ef[i]),cex=0.7)
}

### FIGURE 10.7

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

ltyi<-c(rep(1,6),rep(4,2),2)
a.lo<-c(8.703,9.029,9.369,9.752,10.2,10.66,10.3,9.268,9.287)
a.post<-c(9.245,9.557,9.837,10.23,10.63,11.06,11.1,10.13,9.847)
a.up<-c(10.01,10.25,10.44,10.78,11.12,11.58,11.98,11.21,10.45)
f.val<-c(0.0075,0.016,0.0246,0.03358,0.043,0.0527,0.069,0.044,0.036)
plot(c(8,12),c(0,10),pch=" ",yaxt="n",xlab="average age at infection",ylab=" ")
points(a.post,c(1,2,3,4,5,6,7,8,9),pch="x")
for(i in 1:9){
	lines(c(a.lo[i],a.up[i]),c(i,i),lty=ltyi[i])
   text(a.lo[i]-0.25,i,paste(f.val[i]),cex=0.75)
	}
text(a.lo[7]-1,7,expression(paste("(",alpha[3],"=0)")),font=8)
text(a.lo[8]-0.9,8,expression(paste("(",alpha[3],">0)")),font=8)



