##############################################################
##############################################################
#								             #
#                CHAPTER 10: 				             #
#  fit locat polymonial with logit link                      #
#  kernel = normal                                           #
#  for local linear/quadratic: change the linear predictor!  #
#								             #
# last update: 26/08/2012				             #
##############################################################
##############################################################


### functions
distance<-function(x,y,h.i){
 (x-y)/h.i}

gewicht<-function(x,y,h.i){
 1/h.i * dnorm(distance(x,y,h.i))}

model.itlogit.x <- function(hdat,data.i.1,hhi)
{
h <- hhi
hhh <- hdat
expit<-function(x){
  exp(x)/(1+exp(x))
}
distance<-function(x,y,h.i){
 (x-y)/h.i}
gewicht<-function(x,y,h.i){
 1/h.i * dnorm(distance(x,y,h.i))}
grid.size<-100
grid<-seq(min(hhh$age.i),max(hhh$age.i),length=grid.size)
beta0<-rep(0,grid.size)
beta1<-rep(0,grid.size)
pi.values<-rep(0,grid.size)
hr.values<-rep(0,grid.size)
hr.values1<-rep(0,grid.size)
for (j in 1:grid.size){
     h.i <- hhi[j]
     cat(paste("...",j))
     C<-hhh$age.i-grid[j]	
     Wj<-gewicht(hhh$age.i,grid[j],h.i)
     glmcoef<-glm(hhh$resp.i~C+C^2,family=binomial(link=logit),weights=Wj)$coefficients
     pi.values[j]<-expit(glmcoef[1])
     hr.values[j]<-glmcoef[2]*pi.values[j]
     beta0[j] <-glmcoef[1] 
     beta1[j] <-glmcoef[2] 
     hr.values1[j]<-exp(beta0[j])*beta1[j]/(1+exp(beta0[j]))
}
n.tot <- data.i.1$POS+data.i.1$NEG
#par(mfrow=c(1,2))
#plot(grid,pi.values,ylim=c(0,1),type="l")
#points(data.i.1$AGE,data.i.1$POS/n.tot)
#plot(grid,hr.values,type="l")
#abline(0,0)
#plot(log(grid),beta0)
#plot(1/grid,beta1)
output<-list(n.tot, data.i.1$POS,grid, data.i.1$AGE,pi.values,hr.values,hr.values1,beta0,beta1)
names(output)<-c("n.tot", "POS","grid", "AGE","pi.values","hr.values","hr.values1","beta0","beta1")
return(output)
}

### make binary data ##

make.dat <- function(data.i.1)
{
attach(data.i.1)
n.tot <- POS+NEG
age.i  <- 0
resp.i <- 0
for(i in 1:length(AGE)){
age.i.1  <- rep(AGE[i],n.tot[i])
resp.i.1 <- c(rep(1,POS[i]),rep(0,NEG[i]))
if (NEG[i] == 0) {resp.i.1 <- c(rep(1,POS[i])) }
if (POS[i] == 0) {resp.i.1 <- c(rep(0,NEG[i])) }

age.i    <- c(age.i,age.i.1)
resp.i   <- c(resp.i,resp.i.1)
}
age.i    <- age.i[-1]
resp.i   <- resp.i[-1]
ave.dat <- (POS%*%AGE)/sum(n.tot)
table<-list(age.i,resp.i,ave.dat)
names(table)<-c("age.i","resp.i","ave.dat")
return(table)
}

#########################################################
# PART 1; Rubella                                       #
#########################################################
par(mfrow=c(2,3))
hhh <- make.dat(Rub1)
grid.size<-100
grid<-seq(min(hhh$age.i)+0.5,max(hhh$age.i),length=grid.size)

##########################################################
## calculate the bandwidth for NORMAL kernel !!         ##  
##########################################################

## density estimation for age#############################
ll.1 <- density(hhh$age.i,from=min(hhh$age.i),to=max(hhh$age.i),n=grid.size,window="cosine")
hist(hhh$age.i,nclas=30,col=0,prob=T,xlab="Age",ylab=" ",main="")
f.x <- ll.1$y  
lines(grid,f.x,type="l",lty=1)
title("Desity estimate for the age")

## parameters from the fractional polynomial##############
## rubella ##
p1<- -0.9
p2<- -0.4
beta0<-  6.9687      
beta1<- 10.1530      
beta2<- -18.6327

etai <- beta0+beta1*grid^p1+beta2*grid^p2  
p.i<-exp(etai)/(1+exp(etai))
eta.p.1 <- p1*beta1*grid^(p1-1)+ p2*beta2*grid^(p2-1)
eta.p.2 <- p1*(p1-1)*beta1*grid^(p1-2)+ p2*(p2-1)*beta2*grid^(p2-2)
eta.p.3 <- p1*(p1-1)*(p1-2)*beta1*grid^(p1-3)+ p2*(p2-1)*(p2-2)*beta2*grid^(p2-3)

plot(grid,eta.p.2,type="l",xlab="Age",ylab=" ")
title("Second derivative")
plot(grid,eta.p.3,type="l",xlab="Age",ylab=" ")
title("Third derivative")

##  probability###########################################
#probi <- 1-exp(-exp(etai))
probi <- exp(etai)/(1+exp(etai))

plot(grid,probi,type="l",xlab="Age",ylab=" ")
#points(rrr$age,rrr$posi/rrr$ni)
#points(mmm2$age,mmm2$posi/mmm2$ni)
title("P(a)")

## VAr(Y|X=x)#############################################
var.yxi <- probi*(1-probi)       
plot(grid,var.yxi,type="l",xlab="Age",ylab=" ")
title("Var(Y|a)")

## Integration############################################
## this part produce the same values as in table 3.2 p67 #
## for beta kernels                                      #
#  exp(lgamma(0.5+3)-lgamma(0.5)-lgamma(3))              #
##########################################################

mu2  <- function(z) {{(z^2)*(1-z^2)^2}}
b1   <- function(z) {{(z^4)*(1-z^2)^2}}
b2   <- function(z) {{(z^2*((1-z^2)^2))}}
b2   <- function(z) {{(z*(1-z^2)^2)^2}}
int.mu2   <- integrate(mu2, lower = -1, upper = 1)
int.b.1   <- integrate(b1, lower = -1, upper = 1)
int.b.2   <- integrate(b2, lower = -1, upper = 1)
const.bias <- int.b.1$integral/int.mu2$integral
const.var  <- int.b.2$integral/(int.mu2$integral^2)
cbias <- (const.bias*eta.p.3)/6
cvar <- const.var*(1/var.yxi)*(1/f.x)
hhi <- ((3/7)*cvar/(cbias^2))^(1/7)*length(hhh$age.i)^(-1/7)

#cvpk <- ((6^2*3*const.var)/(4*const.bias^2))^(1/7)

llll.2 <- (1/(var.yxi*f.x*(eta.p.3^2)))^(1/7)
hhi.2  <- 0.884*llll.2*length(hhh$age.i)^(-1/7)
llll.1 <- (1/(var.yxi*f.x*(eta.p.2^2)))^(1/5)
hhi.1  <- 0.776*llll.1*length(hhh$age.i)^(-1/5)
plot(grid,hhi.2,type="l",ylim=c(0,30))
lines(grid,hhi.1,lty=3)
title("Local bandwidth")
legend(0,30,c("p=2,r=1","p=1,r=0"),lty=c(1,3))

hhi.2r<-hhi.2
hhi.1r<-hhi.1
hhh <- make.dat(Rub1)
kkk.r1<-model.itlogit.x(hhh,Rub1,hhi.1r) #local linear
kkk.r2<-model.itlogit.x(hhh,Rub1,hhi.2r) #local quadratic
#xxx1<-model.itlogit.x(hhh,Rub1,hhi.2r)



#########################################################
# PART 2; mumps                                         #
#########################################################

par(mfrow=c(2,3))
hhh <- make.dat(Mump1)
grid.size<-100
grid<-seq(min(hhh$age.i)+0.5,max(hhh$age.i),length=grid.size)

##########################################################
## calculate the bandwidth for NORMAL kernel !!         ##  
##########################################################

## density estimation for age#############################
ll.1 <- density(hhh$age.i,from=min(hhh$age.i),to=max(hhh$age.i),n=grid.size,window="cosine")
hist(hhh$age.i,nclas=30,col=0,prob=T,xlab="Age",ylab=" ",main="")
f.x <- ll.1$y  
lines(grid,f.x,type="l",lty=1)
title("Density estimate for the age")

## parameters from the fractional polynomial
## mumps ##
p1<- -1.2
p2<- -0.9
beta0<- 5.0470
beta1<- 35.2644
beta2<- -41.2659

etai <- beta0+beta1*grid^p1+beta2*grid^p2  
p.i<-exp(etai)/(1+exp(etai))
eta.p.1 <- p1*beta1*grid^(p1-1)+ p2*beta2*grid^(p2-1)
eta.p.2 <- p1*(p1-1)*beta1*grid^(p1-2)+ p2*(p2-1)*beta2*grid^(p2-2)
eta.p.3 <- p1*(p1-1)*(p1-2)*beta1*grid^(p1-3)+ p2*(p2-1)*(p2-2)*beta2*grid^(p2-3)

plot(grid,eta.p.2,type="l",xlab="Age",ylab=" ")
title("Second derivative")
plot(grid,eta.p.3,type="l",xlab="Age",ylab=" ")
title("Third derivative")

##  probability###########################################
#probi <- 1-exp(-exp(etai))
probi <- exp(etai)/(1+exp(etai))

plot(grid,probi,type="l",xlab="Age",ylab=" ")
#points(rrr$age,rrr$posi/rrr$ni)
#points(mmm2$age,mmm2$posi/mmm2$ni)
title("P(a)")

## VAr(Y|X=x)#############################################
var.yxi <- probi*(1-probi)       
plot(grid,var.yxi,type="l",xlab="Age",ylab=" ")
title("Var(Y|a)")

## Integration############################################
## this part produce the same values as in table 3.2 p67 #
## for beta kernels                                      #
#  exp(lgamma(0.5+3)-lgamma(0.5)-lgamma(3))              #
##########################################################

mu2  <- function(z) {{(z^2)*(1-z^2)^2}}
b1   <- function(z) {{(z^4)*(1-z^2)^2}}
b2   <- function(z) {{(z^2*((1-z^2)^2))}}
b2   <- function(z) {{(z*(1-z^2)^2)^2}}
int.mu2   <- integrate(mu2, lower = -1, upper = 1)
int.b.1   <- integrate(b1, lower = -1, upper = 1)
int.b.2   <- integrate(b2, lower = -1, upper = 1)
const.bias <- int.b.1$integral/int.mu2$integral
const.var  <- int.b.2$integral/(int.mu2$integral^2)
cbias <- (const.bias*eta.p.3)/6
cvar <- const.var*(1/var.yxi)*(1/f.x)
hhi <- ((3/7)*cvar/(cbias^2))^(1/7)*length(hhh$age.i)^(-1/7)

#cvpk <- ((6^2*3*const.var)/(4*const.bias^2))^(1/7)

llll.2 <- (1/(var.yxi*f.x*(eta.p.3^2)))^(1/7)
hhi.2  <- 0.884*llll.2*length(hhh$age.i)^(-1/7)
llll.1 <- (1/(var.yxi*f.x*(eta.p.2^2)))^(1/5)
hhi.1  <- 0.776*llll.1*length(hhh$age.i)^(-1/5)
plot(grid,hhi.2,type="l",ylim=c(0,30))
lines(grid,hhi.1,lty=3)
title("Local bandwidth")
legend(0,30,c("p=2,r=1","p=1,r=0"),lty=c(1,3))

hhi.2m<-hhi.2
hhi.1m<-hhi.1
ls()
hhh <- make.dat(Mump1)
kkk.m1<-model.itlogit.x(hhh,Mump1,hhi.1m)
kkk.m2<-model.itlogit.x(hhh,Mump1,hhi.2m)


