#################################################
#################################################
#								#
#                CHAPTER 14: 				#
#  	Who Acquires Infection from Whom?		#
#   		The traditional approach		#
#								#
# last update: 26/08/2012				#
#################################################
#################################################

rm(list=ls(all=TRUE))
setwd("c:/book/chapter14")

### Define Necessary Functions

### PCWRATE.FITTER ####
pcwrate.fitter<-function(y.var,x.var,n.var=rep(1,length(y.var)),breaks,startpar=rep(2e-1,length(breaks)-1)){
hulp1<-function(parms)
{
	parms<-parms^2
	n<-length(y.var)
	int<-rep(0,length(x.var))
	integrand<-rep(0,length(x.var))
	for (i in 1:(length(breaks)-1))
	{
		int<-int+((breaks[i+1]-breaks[i])*parms[i]*(x.var>=breaks[i+1])+(x.var-breaks[i])*parms[i]*(x.var<breaks[i+1])*(x.var>breaks[i]))
		integrand<-integrand+parms[i]*(x.var<breaks[i+1])*(x.var>=breaks[i])
	}
	rate<-integrand
	cumrate<-int
	probhat<-1-exp(-cumrate)
	lli<-y.var*log(probhat+1e-12)+(n.var-y.var)*log(1-probhat+1e-12)
	return(list(ll=-2*sum(lli),x.var=x.var,prob=probhat,rate=rate))
}
hulp2<-function(parms){return(hulp1(parms)$ll)}
result.nlm<-nlm(f=hulp2,p=startpar,iterlim=500,print.level=0,hessian=T)
se<-sqrt(diag(solve(result.nlm$hessian)))
result<-hulp1(result.nlm$estimate)
k<-length(breaks)-1
dev<-result$ll
aic<-dev+2*k
bic<-dev+log(sum(n.var))*k
return(list(prob=result$prob,rate=result$rate^2,aic=aic,bic=bic,deviance=dev,ratevec=round(result.nlm$estimate^2,8),breaks=breaks,x.var,y.var,n.var))
}


# The WAIFW approach: implicit solution
#### WAIFW.6PARMS #####

waifw.6parms<-function(foihat=foihat,muhat=muhat,breaks=breakpoints,N=N,D=D,Lmax=Lmax){
L<-Lmax*mean(exp(-cumsum(muhat*(floor(breakpoints)[-1]-floor(breakpoints)[-length(breakpoints)]))))
phi<-cumsum((foihat+muhat)*(breaks[-1]-breaks[-7]))
psi<-N*D/L*foihat/(foihat+muhat)*(exp(-c(0,phi[-6]))-exp(-phi))
psi[foihat+muhat==0]<-N*D/L*(exp(-c(0,phi[-6]))-exp(-phi))[foihat+muhat==0]

# W1
######
message1<-c("Regular Configuration")
beta<-rep(NA,6);R0vec<-NA;bij<-NA
Dij<-t(matrix(c(
psi[1],0,0,0,0,sum(psi[-1]),
0,psi[2],0,0,0,sum(psi[-2]),
0,0,psi[3],0,0,sum(psi[-3]),
0,0,0,psi[4],0,sum(psi[-4]),
0,0,0,0,psi[5],sum(psi[-5]),
0,0,0,0,0,sum(psi[1:6])),ncol=6))
if(det(Dij)!=0){
	beta<-solve(Dij,foihat)
	if(sum(beta<0)>0){message1<-c("D(lambda)lambda is irregular")}
	if(sum(beta<0)==0){
		bij<-matrix(beta[6],nrow=Lmax,ncol=Lmax)
		bij[1:breaks[2],1:breaks[2]]<-beta[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-beta[2]
		bij[(breaks[3]+1):breaks[4],(breaks[3]+1):breaks[4]]<-beta[3]
		bij[(breaks[4]+1):breaks[5],(breaks[4]+1):breaks[5]]<-beta[4]
		bij[(breaks[5]+1):breaks[6],(breaks[5]+1):breaks[6]]<-beta[5]
		bij[(breaks[6]+1):breaks[7],(breaks[6]+1):breaks[7]]<-beta[6]
		R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
		Mij<-diag(c(My))
		R0vec<-as.real(eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values)
	}}
if (det(Dij)==0){message1<-c("D(lambda) is not invertible")}
beta1<-beta;R0vec1<-R0vec;bij1<-bij

# W2
######
message2<-c("Regular Configuration")
beta<-rep(NA,6);R0vec<-NA;bij<-NA
Dij<-t(matrix(c(
sum(psi[1:2]),0,psi[3],psi[4],psi[5],psi[6],
psi[1],psi[2],psi[3],psi[4],psi[5],psi[6],
0,0,sum(psi[1:3]),psi[4],psi[5],psi[6],
0,0,0,sum(psi[1:4]),psi[5],psi[6],
0,0,0,0,sum(psi[1:5]),psi[6],
0,0,0,0,0,sum(psi[1:6])),ncol=6))
if(det(Dij)!=0){
	beta<-solve(Dij,foihat)
	if(sum(beta<0)>0){message2<-c("D(lambda)lambda is irregular")}
	if(sum(beta<0)==0){
		bij<-matrix(NA,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[3],1:breaks[2]]<-beta[1]
		bij[1:breaks[2],(breaks[2]+1):breaks[3]]<-beta[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-beta[2]
		bij[1:breaks[4],(breaks[3]+1):breaks[4]]<-beta[3]
		bij[(breaks[3]+1):breaks[4],1:breaks[4]]<-beta[3]
		bij[1:breaks[5],(breaks[4]+1):breaks[5]]<-beta[4]
		bij[(breaks[4]+1):breaks[5],1:breaks[5]]<-beta[4]
		bij[1:breaks[6],(breaks[5]+1):breaks[6]]<-beta[5]
		bij[(breaks[5]+1):breaks[6],1:breaks[6]]<-beta[5]
		bij[1:breaks[7],(breaks[6]+1):breaks[7]]<-beta[6]
		bij[(breaks[6]+1):breaks[7],1:breaks[7]]<-beta[6]
		R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
		Mij<-diag(c(My))
		R0vec<-as.real(eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values)
	}}
if (det(Dij)==0){message2<-c("D(lambda) is not invertible")}
beta2<-beta;R0vec2<-R0vec;bij2<-bij

# W3
######
message3<-c("Regular Configuration")
beta<-rep(NA,6);R0vec<-NA;bij<-NA
Dij<-t(matrix(c(
sum(psi[1:3]),0,0,psi[4],psi[5],psi[6],
psi[1],psi[2],psi[3],psi[4],psi[5],psi[6],
psi[1],0,sum(psi[2:3]),psi[4],psi[5],psi[6],
0,0,0,sum(psi[1:4]),psi[5],psi[6],
0,0,0,0,sum(psi[1:5]),psi[6],
0,0,0,0,0,sum(psi[1:6])),ncol=6))
if(det(Dij)!=0){
	beta<-solve(Dij,foihat)
	if(sum(beta<0)>0){message3<-c("D(lambda)lambda is irregular")}
	if(sum(beta<0)==0){
		bij<-matrix(NA,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[4],1:breaks[2]]<-beta[1]
		bij[1:breaks[2],1:breaks[4]]<-beta[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-beta[2]
		bij[(breaks[2]+1):breaks[4],(breaks[3]+1):breaks[4]]<-beta[3]
		bij[(breaks[3]+1):breaks[4],(breaks[2]+1):breaks[4]]<-beta[3]
		bij[1:breaks[5],(breaks[4]+1):breaks[5]]<-beta[4]		
		bij[(breaks[4]+1):breaks[5],1:breaks[5]]<-beta[4]
		bij[1:breaks[6],(breaks[5]+1):breaks[6]]<-beta[5]
		bij[(breaks[5]+1):breaks[6],1:breaks[6]]<-beta[5]
		bij[1:breaks[7],(breaks[6]+1):breaks[7]]<-beta[6]
		bij[(breaks[6]+1):breaks[7],1:breaks[7]]<-beta[6]
		R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
		Mij<-diag(c(My))
		R0vec<-as.real(eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values)
	}}
if (det(Dij)==0){message3<-c("D(lambda) is not invertible")}
beta3<-beta;R0vec3<-R0vec;bij3<-bij

# W4
######
message4<-c("Regular Configuration")
beta<-rep(NA,6);R0vec<-NA;bij<-NA
Dij<-t(matrix(c(
sum(psi[1:6]),0,0,0,0,0,
0,sum(psi[1:6]),0,0,0,0,
0,0,sum(psi[1:6]),0,0,0,
0,0,0,sum(psi[1:6]),0,0,
0,0,0,0,sum(psi[1:6]),0,
0,0,0,0,0,sum(psi[1:6])),ncol=6))
if(det(Dij)!=0){
	beta<-solve(Dij,foihat)
	if(sum(beta<0)>0){message4<-c("D(lambda)lambda is irregular")}
	if(sum(beta<0)==0){
		bij<-matrix(NA,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[2],1:breaks[7]]<-beta[1]
		bij[(breaks[2]+1):breaks[3],1:breaks[7]]<-beta[2]
		bij[(breaks[3]+1):breaks[4],1:breaks[7]]<-beta[3]
		bij[(breaks[4]+1):breaks[5],1:breaks[7]]<-beta[4]
		bij[(breaks[5]+1):breaks[6],1:breaks[7]]<-beta[5]
		bij[(breaks[6]+1):breaks[7],1:breaks[7]]<-beta[6]	
		R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
		Mij<-diag(c(My))
		R0vec<-as.real(eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values)
	}}
if (det(Dij)==0){message4<-c("D(lambda) is not invertible")}
beta4<-beta;R0vec4<-R0vec;bij4<-bij

# W5
######
message5<-c("Regular Configuration")
beta<-rep(NA,6);R0vec<-NA;bij<-NA
Dij<-t(matrix(c(
psi[1],0,0,0,0,sum(psi[-1]),
0,psi[2],0,0,0,sum(psi[-2]),
0,0,psi[3],0,0,sum(psi[-3]),
0,0,0,psi[4],0,sum(psi[-4]),
0,0,0,0,psi[5],sum(psi[-5]),
0,0,0,0,psi[6],sum(psi[1:5])),ncol=6))
if(det(Dij)!=0){
	beta<-solve(Dij,foihat)
	if(sum(beta<0)>0){message5<-c("D(lambda)lambda is irregular")}
	if(sum(beta<0)==0){
		bij<-matrix(beta[6],ncol=Lmax,nrow=Lmax)
		bij[1:breaks[2],1:breaks[2]]<-beta[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-beta[2]
		bij[(breaks[3]+1):breaks[4],(breaks[3]+1):breaks[4]]<-beta[3]
		bij[(breaks[4]+1):breaks[5],(breaks[4]+1):breaks[5]]<-beta[4]
		bij[(breaks[5]+1):breaks[6],(breaks[5]+1):breaks[6]]<-beta[5]
		bij[(breaks[6]+1):breaks[7],(breaks[6]+1):breaks[7]]<-beta[5]
		R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
		Mij<-diag(c(My))
		R0vec<-as.real(eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values)
	}}	
if (det(Dij)==0){message5<-c("D(lambda) is not invertible")}
beta5<-beta;R0vec5<-R0vec;bij5<-bij

# W6
######
message6<-c("Regular Configuration")
beta<-rep(NA,6);R0vec<-NA;bij<-NA
Dij<-t(matrix(c(
psi[1],0,0,0,0,0,
0,psi[2],0,0,0,0,
0,0,psi[3],0,0,0,
0,0,0,psi[4],0,0,
0,0,0,0,psi[5],0,
0,0,0,0,0,psi[6]),ncol=6))
if(det(Dij)!=0){
	beta<-solve(Dij,foihat)
	if(sum(beta<0)>0){message6<-c("D(lambda)lambda is irregular")}^T
	if(sum(beta<0)==0){
		bij<-matrix(0,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[2],1:breaks[2]]<-beta[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-beta[2]
		bij[(breaks[3]+1):breaks[4],(breaks[3]+1):breaks[4]]<-beta[3]
		bij[(breaks[4]+1):breaks[5],(breaks[4]+1):breaks[5]]<-beta[4]
		bij[(breaks[5]+1):breaks[6],(breaks[5]+1):breaks[6]]<-beta[5]
		bij[(breaks[6]+1):breaks[7],(breaks[6]+1):breaks[7]]<-beta[6]
		R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
		Mij<-diag(c(My))
		R0vec<-as.real(eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values)
		print(c(round(max(R0vec),3)))
	}}
if (det(Dij)==0){message6<-c("D(lambda) is not invertible")}
beta6<-beta;R0vec6<-R0vec;bij6<-bij
return(list(w1=list(message=message1,beta=beta1,R0hat=max(R0vec1),bij=bij1,L=L,N=N,D=D),w2=list(message=message2,beta=beta2,R0hat=max(R0vec2),bij=bij2,L=L,N=N,D=D),w3=list(message=message3,beta=beta3,R0hat=max(R0vec3),bij=bij3,L=L,N=N,D=D),
w4=list(message=message4,beta=beta4,R0hat=max(R0vec4),bij=bij4,L=L,N=N,D=D),w5=list(message=message5,beta=beta5,R0hat=max(R0vec5),bij=bij5,L=L,N=N,D=D),w6=list(message=message6,beta=beta6,R0hat=max(R0vec6),bij=bij6,L=L,N=N,D=D)))
}



####  WAIFW.FITTER #####
waifw.fitter<-function(a,y,n=rep(1,length(y)),waifw.choice,muy,breaks,N,D,Lmax,startpar=NULL,plots="TRUE"){
L<-Lmax*mean(exp(-cumsum(muy)))
waifwproc<-function(a,y,b,n=rep(1,length(y)),waifw=waifw.choice,muy,breaks,Lmax,N,D,plots="TRUE"){
	b<-round(b^2,8)
	if (waifw==1){
		bij<-matrix(b[6],nrow=Lmax,ncol=Lmax)
		bij[1:breaks[2],1:breaks[2]]<-b[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-b[2]
		bij[(breaks[3]+1):breaks[4],(breaks[3]+1):breaks[4]]<-b[3]
		bij[(breaks[4]+1):breaks[5],(breaks[4]+1):breaks[5]]<-b[4]
		bij[(breaks[5]+1):breaks[6],(breaks[5]+1):breaks[6]]<-b[5]
		bij[(breaks[6]+1):breaks[7],(breaks[6]+1):breaks[7]]<-b[6]
	}
	if (waifw==2){
		bij<-matrix(NA,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[3],1:breaks[2]]<-b[1]
		bij[1:breaks[2],(breaks[2]+1):breaks[3]]<-b[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-b[2]
		bij[1:breaks[4],(breaks[3]+1):breaks[4]]<-b[3]
		bij[(breaks[3]+1):breaks[4],1:breaks[4]]<-b[3]
		bij[1:breaks[5],(breaks[4]+1):breaks[5]]<-b[4]
		bij[(breaks[4]+1):breaks[5],1:breaks[5]]<-b[4]
		bij[1:breaks[6],(breaks[5]+1):breaks[6]]<-b[5]
		bij[(breaks[5]+1):breaks[6],1:breaks[6]]<-b[5]
		bij[1:breaks[7],(breaks[6]+1):breaks[7]]<-b[6]
		bij[(breaks[6]+1):breaks[7],1:breaks[7]]<-b[6]
	}
	if (waifw==3){
		bij<-matrix(NA,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[4],1:breaks[2]]<-b[1]
		bij[1:breaks[2],1:breaks[4]]<-b[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-b[2]
		bij[(breaks[2]+1):breaks[4],(breaks[3]+1):breaks[4]]<-b[3]
		bij[(breaks[3]+1):breaks[4],(breaks[2]+1):breaks[4]]<-b[3]
		bij[1:breaks[5],(breaks[4]+1):breaks[5]]<-b[4]		
		bij[(breaks[4]+1):breaks[5],1:breaks[5]]<-b[4]
		bij[1:breaks[6],(breaks[5]+1):breaks[6]]<-b[5]
		bij[(breaks[5]+1):breaks[6],1:breaks[6]]<-b[5]
		bij[1:breaks[7],(breaks[6]+1):breaks[7]]<-b[6]
		bij[(breaks[6]+1):breaks[7],1:breaks[7]]<-b[6]
	}
	if (waifw==4){
		bij<-matrix(NA,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[2],1:breaks[7]]<-b[1]
		bij[(breaks[2]+1):breaks[3],1:breaks[7]]<-b[2]
		bij[(breaks[3]+1):breaks[4],1:breaks[7]]<-b[3]
		bij[(breaks[4]+1):breaks[5],1:breaks[7]]<-b[4]
		bij[(breaks[5]+1):breaks[6],1:breaks[7]]<-b[5]
		bij[(breaks[6]+1):breaks[7],1:breaks[7]]<-b[6]	
	}
	if (waifw==5){
		bij<-matrix(b[6],ncol=Lmax,nrow=Lmax)
		bij[1:breaks[2],1:breaks[2]]<-b[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-b[2]
		bij[(breaks[3]+1):breaks[4],(breaks[3]+1):breaks[4]]<-b[3]
		bij[(breaks[4]+1):breaks[5],(breaks[4]+1):breaks[5]]<-b[4]
		bij[(breaks[5]+1):breaks[6],(breaks[5]+1):breaks[6]]<-b[5]
		bij[(breaks[6]+1):breaks[7],(breaks[6]+1):breaks[7]]<-b[5]
	}
	if (waifw==6){
		bij<-matrix(0,ncol=Lmax,nrow=Lmax)
		bij[1:breaks[2],1:breaks[2]]<-b[1]
		bij[(breaks[2]+1):breaks[3],(breaks[2]+1):breaks[3]]<-b[2]
		bij[(breaks[3]+1):breaks[4],(breaks[3]+1):breaks[4]]<-b[3]
		bij[(breaks[4]+1):breaks[5],(breaks[4]+1):breaks[5]]<-b[4]
		bij[(breaks[5]+1):breaks[6],(breaks[5]+1):breaks[6]]<-b[5]
		bij[(breaks[6]+1):breaks[7],(breaks[6]+1):breaks[7]]<-b[6]
	}
	foiiprev<-rep(pcwrate.fitter(y.var=y,x.var=a,n.var=n,breaks=breakpoints)$ratevec,c(breakpoints[2],diff(breakpoints[-1])))
	tol<-1
	it<-0
	while ((tol>1e-15)&(it<5000)){
		foii<-(N/L)*D*bij%*%(as.matrix(foiiprev/(foiiprev+muy))*matrix(c(1-exp(-(1-A)*(foiiprev[1]+muy[1])),exp(-(1-A)*(foiiprev[1]+muy[1])-c(0,cumsum(foiiprev[-1]+muy[-1])[1:(Lmax-2)]))-exp(-(1-A)*(foiiprev[1]+muy[1])-c(cumsum(foiiprev[-1]+muy[-1])))),ncol=1))		
		foii<- apply(cbind(0,foii),1,max)
		foii<- apply(cbind(1,foii),1,min)
		tol<-sum((foii-foiiprev)^2)
		it<-it+1
		foiiprev<-foii
	}
	if (plots=="TRUE"){
		par(mfrow=c(1,1))
    		par(mar=c(5,4,4,4)+0.3)
            plot(c(A,1:max(floor(a))),1-exp(c(0,-(1-A)*foii[1],-(1-A)*foii[1]-cumsum(foii[-1])[1:(max(floor(a))-1)])),type="l",xlab="age",ylab="prevalence",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),1-exp(-(1-A)*foii[1]-cumsum(foii[-1])[max(floor(a)):(Lmax-2)]),lty=2,lwd=2)
            htab<-table(floor(a),y)
            points(c(A,sort(unique(floor(a)))[-1]),htab[,2]/(htab[,1]+htab[,2]),cex=0.02*(htab[,1]+htab[,2]),lwd=1.1)
            par(new=TRUE)
            plot(c(A,1:max(floor(a))),foii[1:(max(floor(a))+1)],type="l",axes=FALSE,bty="n",xlab="",ylab="",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),foii[(max(floor(a))+2):Lmax],lty=2,lwd=2)
            axis(4,at=pretty(range(foii)))
		#contour(c(0:(Lmax-1)),c(0:(Lmax-1)),bij,xlab="age of susceptible",ylab="age of infectious")
	}	
	prev<-rep(NA,length(a))
	ll<-rep(NA,length(a))
	for (i in 1:length(a)){
		prev[i]<-(1-exp(c(-(a[i]-A)*foii[1],-(1-A)*foii[1]-cumsum(c(0,foii[-1]))-(foii[-1])[floor(a[i])]*(a[i]-floor(a[i])))))[floor(a[i])+1]
		ll[i]<-y[i]*log(prev[i]+1e-8)+(n[i]-y[i])*log(1-prev[i]+1e-8)
	}
	R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
	Mij<-diag(c(My))
	R0vec<-eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values
	return(list(ll=-2*sum(ll),eivalues=R0vec,prev=prev,bij=bij))
}
waifwproc.fitter<-function(b){return(waifwproc(a=a,y=y,n=n,b=b,waifw=waifw.choice,muy=muy,breaks=breakpoints,Lmax=Lmax,N=N,D=D)$ll)}
maxna<-function(x){return(max(x,na.rm=T))}
if (is.null(startpar)){
if (waifw.choice==1){startpar<-apply(cbind(waifw6.fit$w1$beta,rep(0,6)),1,maxna)}
if (waifw.choice==2){startpar<-apply(cbind(waifw6.fit$w2$beta,rep(0,6)),1,maxna)}
if (waifw.choice==3){startpar<-apply(cbind(waifw6.fit$w3$beta,rep(0,6)),1,maxna)}
if (waifw.choice==4){startpar<-apply(cbind(waifw6.fit$w4$beta,rep(0,6)),1,maxna)}
if (waifw.choice==5){startpar<-apply(cbind(waifw6.fit$w5$beta,rep(0,6)),1,maxna)}
if (waifw.choice==6){startpar<-apply(cbind(waifw6.fit$w6$beta,rep(0,6)),1,maxna)}
}
waifw.result<-nlm(waifwproc.fitter,sqrt(startpar),print.level = 0)
result.global<-waifwproc(a=a,y=y,b=waifw.result$estimate,waifw=waifw.choice,muy=muy,breaks=breakpoints,Lmax=Lmax,N=N,D=D)
return(list(deviance=result.global$ll,aic=result.global$ll+6*2,bic=result.global$ll+6*log(length(y)),bij=result.global$bij,R0=max(as.real(result.global$eivalues)),N=N,D=D,L=L))
}

# Surface fit (Farrington and Whitaker 2005)
# Reparametrization: alpha=beta; gamma=(alpha+beta+1)^-1; sigma=nu^-2

##### SURFACE.FITTER #######
surface.fitter<-function(a,y,muy,Lmax,N,D,startpar=c(9e-5,8.1,0.5,0.17,0.001),plots="TRUE"){
L<-Lmax*mean(exp(-cumsum(muy)))
sproc1<-function(a,y,kappa,mu,sigma,gamm,delta,Lmax,N,D,plots="TRUE"){
	bxy<-function(x,y){
		u<-(x+y)/sqrt(2); v<-(x-y)/sqrt(2)
		ifelse(sigma<1,cstar<-(sqrt(2)*mu*(1-sigma^2))^(1-(sigma^-2))*exp((sigma^-2)-1),cstar<-1)
		gammau<-cstar*u^((sigma^-2)-1)*exp(-u/(sqrt(2)*mu*sigma^2))
		bvu<-(1-(v/u)^2)^(0.5*(1/gamm-1)-1)
		#if (plots=="TRUE"){par(mfrow=c(2,2)); plot(u,gammau); plot(v,bvu)}
		result<-kappa*(gammau*bvu+delta^2)
		return(result)
	}
	bij<-outer(c(1:Lmax),c(1:Lmax),bxy)
	foiiprev<-rep(0.01,Lmax)
	tol<-1
	it<-0
	while ((tol>1e-15)&(it<2000)){
		foii<-(N/L)*D*bij%*%(as.matrix(foiiprev/(foiiprev+muy))*matrix(c(1-exp(-(1-A)*(foiiprev[1]+muy[1])),exp(-(1-A)*(foiiprev[1]+muy[1])-c(0,cumsum(foiiprev[-1]+muy[-1])[1:(Lmax-2)]))-exp(-(1-A)*(foiiprev[1]+muy[1])-c(cumsum(foiiprev[-1]+muy[-1])))),ncol=1))		
		foii<- apply(cbind(0,foii),1,max)
		foii<- apply(cbind(1,foii),1,min)
		tol<-sum((foii-foiiprev)^2)
		it<-it+1
		foiiprev<-foii
	}
	if (plots=="TRUE"){
    		par(mar=c(5,4,4,4)+0.3)
            plot(c(A,1:max(floor(a))),1-exp(c(0,-(1-A)*foii[1],-(1-A)*foii[1]-cumsum(foii[-1])[1:(max(floor(a))-1)])),type="l",xlab="age",ylab="prevalence",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),1-exp(-(1-A)*foii[1]-cumsum(foii[-1])[max(floor(a)):(Lmax-2)]),lty=2,lwd=2)
            htab<-table(floor(a),y)
            points(c(A,sort(unique(floor(a)))[-1]),htab[,2]/(htab[,1]+htab[,2]),cex=0.02*(htab[,1]+htab[,2]),lwd=1.1)
            par(new=TRUE)
            plot(c(A,1:max(floor(a))),foii[1:(max(floor(a))+1)],type="l",axes=FALSE,bty="n",xlab="",ylab="",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),foii[(max(floor(a))+2):Lmax],lty=2,lwd=2)
            axis(4,at=pretty(range(foii)))
            mtext("force of infection",4,3)
	}	
	prev<-rep(NA,length(a))
	ll<-rep(NA,length(a))
	for (i in 1:length(a)){
		prev[i]<-(1-exp(c(-(a[i]-A)*foii[1],-(1-A)*foii[1]-cumsum(c(0,foii[-1]))-(foii[-1])[floor(a[i])]*(a[i]-floor(a[i])))))[floor(a[i])+1]
		ll[i]<-y[i]*log(prev[i]+1e-8)+(1-y[i])*log(1-prev[i]+1e-8)
	}
	R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
	Mij<-diag(c(My))
	R0vec<-eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values
	return(list(ll=-2*sum(ll),eivalues=R0vec,prev=prev,bij=bij,foi=foiiprev))
}
sproc2<-function(p){return(sproc1(a,y,kappa=p[1],mu=p[2],sigma=p[3],gamm=p[4],delta=p[5],Lmax,N,D)$ll)}
fit<-optim(startpar,sproc2,control=list(maxit=2000),hessian=T)
phat<-fit$par
result<-sproc1(a,y,kappa=phat[1],mu=phat[2],sigma=phat[3],gamm=phat[4],delta=phat[5],Lmax=Lmax,N=N,D=D)
if (plots=="TRUE"){
#win.graph(); #par(mfrow=c(1,1))
persp(c(0,A,1:99),c(0,A,1:99),N*D/L*rbind(rep(0,Lmax+1),cbind(rep(0,Lmax),result$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)
#win.graph(); #par(mfrow=c(1,1))
contour(c(0,A,1:99),c(0,A,1:99),N*D/L*rbind(rep(0,Lmax+1),cbind(rep(0,Lmax),result$bij)))
}
return(list(parms=list(kappa=phat[1],mu=phat[2],sigma=phat[3],gamm=phat[4],delta=phat[5]),deviance=fit$value,aic=fit$value+5*2,bic=fit$value+5*log(length(y)),bij=result$bij,foi=result$foi,R0=max(as.real(result$eivalues))))
}

##################################################
## Section 14.2: Estimating From Serological Data#
##								 #
##################################################


### Estimating the mortality function for 2006 for Belgium (source: EUROSTAT)
ND<-c(489,47,29,21,12,12,16,15,15,6,6,14,17,19,17,23,34,33,62,71,68,68,78,71,71,96,86,83,79,80,83,93,126,120,121,132,135,176,161,193,196,218,257,277,331,376,356,435,460,453,535,545,576,668,692,759,722,819,939,1015,1051,973,1113,996,940,1074,1252,1367,1468,1541,1661,1838,2012,2236,2517,2793,2938,2994,3311,3516,3727,3857,4088,4161,4261,4274,4061,2509,2049,2159,2205,2550,2330,1992,1569,1242,1000,726,533,996)
PS<-c(118366,117271,114562,113894,116275,118030,116761,117742,119583,119887,118963,119958,124637,129143,131030,129724,127187,126433,124377,124883,122201,124482,126459,130129,133897,135009,134516,133495,132705,132040,130602,135638,140537,146151,150467,152113,151656,151412,153371,158268,162456,167652,164871,161671,162060,159735,160672,157030,153820,151114,148978,145929,142374,141215,135525,135968,134692,135991,134291,134131,113024,112198,105880,92772,84462,93787,100820,101866,97208,94145,92451,93027,91640,93593,91933,89900,81718,77891,73104,70082,67057,62178,57642,51786,47466,42065,28004,17186,14492,13838,13957,13358,10442,8063,5604,4289,2843,2068,1368,2146)
AGE<-c(0:(length(ND)-1))

library(mgcv)

demfit<-gam(ND~s(AGE),offset=log(PS),family="poisson",link="log")
muy<-predict(demfit,type="response")
My<-exp(-cumsum(muy))
L<-mean(My)*100

### FIGURE 14.1
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

plot(AGE,My,xlab="Age",ylab="Mortality function (BE 2006)",type="l",lwd=2,ylim=c(0,1))
lines(AGE,muy,lwd=2,lty=2)
points(AGE,ND/PS,cex=1,lwd=2)

### PARAMETERS
# Mean duration of infectiousness
D<-6/365
# Maximum life (if type mortality this is the life expectancy)
Lmax<-100
# Population size
N<-sum(PS)
# Age of loss of maternal immunity (0<A<1)
A<-0.5
# Mortality function
My<-My[1:Lmax]
muy<-muy[1:Lmax]
# Age category
breakpoints<-c(0.5,2,6,12,19,31,100)

##################################################
## Section 14.2: Estimating From Serological Data#
##								 #
## 14.2.2. Imposing Mixing Patterns: the         #
##   traditional approach of Anderson and May    # 
##################################################


### Reading in the data: Parvovirus B19 in Belgium
vzv.parvo.be<-read.table("c:/book/chapter4/VZV-B19-BE.dat",header=T)
vzv.parvo.be<-vzv.parvo.be[!is.na(vzv.parvo.be$parvores)&!is.na(vzv.parvo.be$age)&vzv.parvo.be$age<70&vzv.parvo.be$age>=1,]
#vzv.parvo.be<-vzv.parvo.be[!is.na(vzv.parvo.be$VZVres)&!is.na(vzv.parvo.be$age)&vzv.parvo.be$age<70&vzv.parvo.be$age>=0.5,]
vzv.parvo.be<-vzv.parvo.be[order(vzv.parvo.be$age),]
names(vzv.parvo.be)
#y<-vzv.parvo.be$VZVres
y<-vzv.parvo.be$parvores
a<-vzv.parvo.be$age


# The WAIFW approach: explicit solution
# Monotonized piecewise constant FOI
pcw.fit<-pcwrate.fitter(y.var=y,x.var=a,breaks=breakpoints)
foihat<-pcw.fit$ratevec

# Constant mortality rate
muhat<-rep(NA,(length(breakpoints)-1))
for (i in 1:(length(breakpoints)-1)){muhat[i]<-mean(muy[(floor(breakpoints)[i]+1):(floor(breakpoints)[i+1])])}
#points(floor(breakpoints)[-length(breakpoints)]+diff(floor(breakpoints))/2,muhat,pch=2,cex=5)


### FIGURE 14.2
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

htab<-table(floor(a),y)
pos<-htab[,2]
neg<-htab[,1]
tot<-pos+neg
plot(c(A,sort(unique(floor(a)))[-1]),pos/tot,cex=0.02*tot,lwd=2,,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,72),ylim=c(0,1))
lines(a,pcw.fit$prob,lwd=2)
for (i in 1:(length(breakpoints)-1)){lines(c(breakpoints[i],min(breakpoints[i+1],max(a))),c(foihat[i],foihat[i]),lwd=2)}
for (i in 2:(length(breakpoints)-1)){lines(c(breakpoints[i],breakpoints[i]),c(foihat[i-1],foihat[i]),lwd=2,lty=3)}
axis(4,at=c(0.,0.05,0.10,0.15))
#axis(4,at=pretty(range(foihat)))

# Run this first to see which matrix is invertible/regular and to obtain estimates for the regular configurations
# It makes no sense to run the waifw.fitter to settings where there is a non-invertible matrix
# (The fitter code will not work without this object)
waifw6.fit<-waifw.6parms(foihat=foihat,muhat=muhat,breaks=breakpoints,N=N,D=D,Lmax=Lmax)
waifw6.fit

# Deriving waifw-matrices from pcw foi and mortality rate

#w1<-waifw.fitter(a=a,y=y,waifw.choice=1,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
#w2<-waifw.fitter(a=a,y=y,waifw.choice=2,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
#w3<-waifw.fitter(a=a,y=y,waifw.choice=3,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
#w4<-waifw.fitter(a=a,y=y,waifw.choice=4,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
#w5<-waifw.fitter(a=a,y=y,waifw.choice=5,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
#w6<-waifw.fitter(a=a,y=y,waifw.choice=6,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")

### FIGURE 14.3a
w2<-waifw.fitter(a=a,y=y,waifw.choice=2,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))
persp(c(0,1:Lmax),c(0,1:Lmax),N*D/L*cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),w2$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)

### FIGURE 14.3b
w3<-waifw.fitter(a=a,y=y,waifw.choice=3,muy=muy,breaks=breakpoints,N=N,D=D,Lmax=Lmax,plots="TRUE")
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))
persp(c(0,1:Lmax),c(0,1:Lmax),N*D/L*cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),w3$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)

### FIGURE 14.3c
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=1,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))
waifw.plot<-waifw6.fit$w4
persp(c(0,1:(Lmax)),c(0,1:(Lmax)),cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),waifw.plot$N*waifw.plot$D/waifw.plot$L*waifw.plot$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)

### FIGURE 14.3d
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))
waifw.plot<-waifw6.fit$w5
persp(c(0,1:(Lmax)),c(0,1:(Lmax)),cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),waifw.plot$N*waifw.plot$D/waifw.plot$L*waifw.plot$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)


##################################################
## Section 14.2: Estimating From Serological Data#
##								 #
## 14.2.3. Exploiting an Underlying Continuous   #
##         Mixing Surface                        #
##################################################

### FIGURE 14.4
for (i in 1:2){

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))
if (i==1){kappa=1e-6;mu=25;sigma=1;gamm=0.1}
if (i==2){kappa=1e-6;mu=25;sigma=0.5;gamm=0.2}
	bxy<-function(x,y){
		u<-(x+y)/sqrt(2); v<-(x-y)/sqrt(2)
		ifelse(sigma<1,cstar<-(sqrt(2)*mu*(1-sigma^2))^(1-(sigma^-2))*exp((sigma^-2)-1),cstar<-1)
		gammau<-cstar*u^((sigma^-2)-1)*exp(-u/(sqrt(2)*mu*sigma^2))
		bvu<-(1-(v/u)^2)^(0.5*(1/gamm-1)-1)
		#if (plots=="TRUE"){par(mfrow=c(2,2)); plot(u,gammau); plot(v,bvu)}
		result<-kappa*(gammau*bvu)
		return(result)
	}
bij<-outer(c(1:Lmax),c(1:Lmax),bxy)
contour(c(0:(Lmax-1)),c(0:(Lmax-1)),bij,xlab="a",ylab="a'")
}


##################################################
## Section 14.3: Topics in Estimating WAIFW      #
##		     Matrices				 #
##################################################


### FIGURE 14.5
windows(record=TRUE, width=5, height=5)
par(cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))
#surface1<-surface.fitter(a=a,y=y,muy=muy,Lmax=Lmax,N=N,D=D,startpar=c(8e-5,8.1,0.5,0.17,0.001))
#surface2<-surface.fitter(a=a,y=y,muy=muy,Lmax=Lmax,N=N,D=D,startpar=c(8e-5,10.1,0.8,0.17,0.001))
#surface3<-surface.fitter(a=a,y=y,muy=muy,Lmax=Lmax,N=N,D=D,startpar=c(8e-5,8.1,0.6,0.17,0.001))
surface4<-surface.fitter(a=a,y=y,muy=muy,Lmax=Lmax,N=N,D=D,startpar=c(9.593714e-05,7.647424e+00,4.999767e-01,1.227393e-01,1.933637e-01))


##########################
# OTHER USEFUL FUNCTIONS #
##########################
# 1) Alternative for the crude coding of the WAIFW matrices in waifw6.parms
	bxy<-function(xi,yi){
			i<-as.numeric(cut(xi,breaks,include.lowest = TRUE, right = FALSE))
			j<-as.numeric(cut(yi,breaks,include.lowest = TRUE, right = FALSE))
			if (waifw==1){
				result<-matrix(c(b[1],b[6],b[6],b[6],b[6],b[6],
					 	     b[6],b[2],b[6],b[6],b[6],b[6],
					           b[6],b[6],b[3],b[6],b[6],b[6],
 					 	     b[6],b[6],b[6],b[4],b[6],b[6],
					 	     b[6],b[6],b[6],b[6],b[5],b[6],
					 	     b[6],b[6],b[6],b[6],b[6],b[6])^2,ncol=6)[i,j]
			}
			if (waifw==2){
				result<-matrix(c(b[1],b[1],b[3],b[4],b[5],b[6],
					 	     b[1],b[2],b[3],b[4],b[5],b[6],
					           b[3],b[3],b[3],b[4],b[5],b[6],
 					 	     b[4],b[4],b[4],b[4],b[5],b[6],
					 	     b[5],b[5],b[5],b[5],b[5],b[6],
					 	     b[6],b[6],b[6],b[6],b[6],b[6])^2,ncol=6)[i,j]
			}
			if (waifw==3){
				result<-matrix(c(b[1],b[1],b[1],b[4],b[5],b[6],
					 	     b[1],b[2],b[3],b[4],b[5],b[6],
					           b[1],b[3],b[3],b[4],b[5],b[6],
 					 	     b[4],b[4],b[4],b[4],b[5],b[6],
					 	     b[5],b[5],b[5],b[5],b[5],b[6],
					 	     b[6],b[6],b[6],b[6],b[6],b[6])^2,ncol=6)[i,j]
			}
			if (waifw==4){
				result<-matrix(c(b[1],b[1],b[1],b[1],b[1],b[1],
					 	     b[2],b[2],b[2],b[2],b[2],b[2],
					           b[3],b[3],b[3],b[3],b[3],b[3],
 					 	     b[4],b[4],b[4],b[4],b[4],b[4],
					 	     b[5],b[5],b[5],b[5],b[5],b[5],
					 	     b[6],b[6],b[6],b[6],b[6],b[6])^2,ncol=6)[i,j]
			}
			if (waifw==5){
				result<-matrix(c(b[1],b[6],b[6],b[6],b[6],b[6],
					 	     b[6],b[2],b[6],b[6],b[6],b[6],
					           b[6],b[6],b[3],b[6],b[6],b[6],
 					 	     b[6],b[6],b[6],b[4],b[6],b[6],
					 	     b[6],b[6],b[6],b[6],b[5],b[6],
					 	     b[6],b[6],b[6],b[6],b[6],b[5])^2,ncol=6)[i,j]
			}
			if (waifw==6){
				result<-matrix(c(b[1], 0  , 0  , 0  , 0  , 0  ,
					 	      0  ,b[2], 0  , 0  , 0  , 0  ,
					            0  , 0  ,b[3], 0  , 0  , 0  ,
 					 	      0  , 0  , 0  ,b[4], 0  , 0  ,
					 	      0  , 0  , 0  , 0  ,b[5], 0  ,
					 	      0  , 0  , 0  , 0  , 0  ,b[6])^2,ncol=6)[i,j]
			}
			return(result)
	}
	bij<-matrix(rep(0,Lmax*Lmax),ncol=Lmax)
	for (xx in 1:Lmax){
		for (yy in 1:Lmax){
			bij[xx,yy]<-bxy(xx,yy);
		}
	}

