#################################################
#################################################
#								#
#                CHAPTER 11: 				#
#  Modelling the Prevalence and the Force of	#
#    Infection Directly from Antibody Levels	#
#								#
# last update: 26/08/2012				#
#################################################
#################################################

rm(list=ls(all=TRUE))
setwd("c:/book/chapter11")

### Defining some fucntions

### Numerical Approximation of the FOI
foi.num<-function(x,p)
{
grid<-sort(unique(x))
pgrid<-(p[order(x)])[duplicated(sort(x))==F]
dp<-diff(pgrid)/diff(grid)
foi<-approx((grid[-1]+grid[-length(grid)])/2,dp,grid[c(-1,-length(grid))])$y/(1-pgrid[c(-1,-length(grid))])
return(list(grid=grid[c(-1,-length(grid))],foi=foi))
}

### Numerical Approximation of the derivative mu'(a) of the mean antibody level
mu.der.num<-function(x,mu)
{
grid<-sort(unique(x))
mugrid<-(mu[order(x)])[duplicated(sort(x))==F]
dmu<-diff(mugrid)/diff(grid)
dermu<-approx((grid[-1]+grid[-length(grid)])/2,dmu,grid[c(-1,-length(grid))])$y
return(list(grid=grid[c(-1,-length(grid))],mu=mugrid[c(-1,-length(grid))],dermu=dermu))
}


#################################################
## Section 11.1: Serological and Current Status	#
##               Data					#
##								#
#################################################

### reading the VZV data
data<-read.table("c:/book/chapter4/VZV-b19-BE.dat",header=T)
head(data)
subset1<-(data$age<40.5)&(!is.na(data$age))&(!is.na(data$VZVmUIml))
subset2<-(data$age<40.5)&(!is.na(data$age))&(!is.na(data$VZVmUIml)&(!is.na(data$VZVres)))
data1<-data[subset1,]
data2=data[subset2,]

### data to use when taking the continuous levels
z1<-log(data1$VZVmUIml[order(data1$age)]+1)
a1<-data1$age[order(data1$age)]

#### data to use when taking the binary indicators (different because some are inconclusive)
y2<-data2$VZVres[order(data2$age)]
a2<-data2$age[order(data2$age)]


### FIGURE 11.1
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(3, 0.5, 0))

plot(a1,z1,main="",pch=16,xlab="age",ylab="log(antibody levels+1)",xlim=c(0,40.5),cex=0.5,col="dark grey")
abline(h=log(51))
abline(h=log(101))
abline(h=2.316,lty=5,lwd=2)  #mean of lower component of mixture, fitted in code below
abline(h=6.338,lty=5,lwd=2)  #mean of upper component of mixture, fitted in code below

source("monotone logistic and gaussian psplinefit.R")

#### IN THE FUNCTION mpspline.fitter USE FINER GRID TO GET FINER PLOT by=0.1 instead of by=1
#### x.seq <- seq(xl, xr, by=0.1)
#### selecting the best smoothing parameter with BIC
alphagrid=seq(0.01,1,by=0.01)
res=matrix(ncol=2,nrow=length(alphagrid))
for (i in (1:length(alphagrid))){
fitC=mpspline.fitter(response=z1,x.var=a1,ps.intervals=20,degree=3,order=2,alpha=alphagrid[i],kappa=1e8)
res[i,1]=alphagrid[i]
res[i,2]=fitC$bic
}
alphafin=res[res[,2]==min(res[,2]),1]
fitC=mpspline.fitter(response=z1,x.var=a1,ps.intervals=20,degree=3,order=2,alpha=alphafin,kappa=1e8)
lines(fitC$x,fitC$y,lwd=3,lty=1)


### FIGURE 11.2
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(3, 0.5, 0))

x<-seq(-2,22,0.01)
ynorm1<-dnorm(x,7,2)
ynorm2<-dnorm(x,13,2)
plot(x[x<15],ynorm1[x<15],type="l",lty=1,xlim=c(-3,23),xlab=" ",ylab=" ",axes=FALSE)
box()
axis(1,tick=FALSE,at=c(30))
lines(x[x>5],ynorm2[x>5],lty=1)
abline(v=7,lwd=2)
abline(v=13,lwd=2)
arrows(3,0.15,7,0.10,length=0.1,lwd=2)
arrows(17,0.15,13,0.10,length=0.1,lwd=2)
mtext("susceptible      infected",side=1,line=0.4)
mtext(c(expression(paste(mu[1],"               ",mu[2]))),side=3,line=0.4)
text(0.5,0.175,"mean antibody")
text(0.5,0.16,"for susceptible")
text(19.5,0.175,"mean antibody")
text(19.5,0.16,"for infected")
arrows(7,-0.001,13,-0.001,length=0.1,lwd=2)
arrows(13,-0.001,7,-0.001,length=0.1,lwd=2)
text(10,0.01,"d")

#################################################
## Section 11.2: The Threshold Approach    	#
##               Data					#
#################################################

### selecting the best smoothing parameter with BIC
alphagrid=seq(1,100,by=1)
res=matrix(ncol=2,nrow=length(alphagrid))
for (i in (1:length(alphagrid))){
fit1=mpspline.fitter(response=y2,x.var=a2,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",alpha=alphagrid[i],kappa=1e8)
res[i,1]=alphagrid[i]
res[i,2]=fit1$bic
}
alphafin=res[res[,2]==min(res[,2]),1]
fit1=mpspline.fitter(response=y2,x.var=a2,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",alpha=alphafin,kappa=1e8)
grid<-sort(unique(round(a2)))
neg<-table(y2,round(a2))[1,]
pos<-table(y2,round(a2))[2,]
tot<-neg+pos

### FIGURE 11.4
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2.5, 0.5, 0),mar=c(5.1,3.5,4.1,4))

plot(grid,pos/tot,cex=0.02*tot,xlab="age",ylab="seroprevalence",xlim=c(0,max(grid)),ylim=c(0,1),lwd=2)
lines(fit1$x,fit1$y,lwd=2,lty=1)
lines(foi.num(fit1$x,fit1$y)$grid,foi.num(fit1$x,fit1$y)$foi,lwd=2,lty=1)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
mtext(side=4,las=3,"force-of-infection",line=1.5)
#abline(h=0,lwd=2)

#################################################
## Section 11.4: Application to VZV Data 		#
##      							#
##  11.4.3 Combining the mixture with the least #
##         squares regression fit			#
#################################################

library(mixdist)
zmixdat=mixgroup(z1,breaks=40)
zstartpar=mixparam(pi=c(0.2,0.8),mu=c(2,6),sigma=c(0.5,1))
mixfit=mix(zmixdat,zstartpar,dist="norm")
summary(mixfit)

### FIGURE 11.3
plot(mixfit)
coef(mixfit)

#################################################
## Section 11.4: Application to VZV Data 		#
##      							#
##  11.4.1 Fitting a Mixture                    #
##         squares regression fit			#
#################################################

### FIGURE 11.5
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2.5, 0.5, 0),mar=c(5.1,3.5,4.1,4))

plot(grid,pos/tot,cex=0.02*tot,xlab="age",ylab="seroprevalence",xlim=c(0,max(grid)),ylim=c(0,1),lwd=2)
lines(fit1$x,fit1$y,lty=2,lwd=3)
lines(foi.num(fit1$x,fit1$y)$grid,foi.num(fit1$x,fit1$y)$foi/2,lty=2,lwd=3)
axis(side=4,at=c(0.0,0.2,0.4),labels=c(0.0,0.2,0.4)/2)
#abline(h=0,lwd=2)
lines(fitC$x,(fitC$y-2.316)/(6.338-2.316),lty=1,lwd=3)
foimu=mu.der.num(fitC$x,fitC$y)$dermu/(6.338-mu.der.num(fitC$x,fitC$y)$mu)
lines(mu.der.num(fitC$x,fitC$y)$grid,foimu/2,lty=1,lwd=3)
mtext(side=4,las=3,"force-of-infection",line=1.5)

#################################################
## Section 11.5: Modeling the Force of Infection#
##      	directly from antibody titers using #
##      	hierarchical mixture models         #
##      							#
##  11.5.3 Application to the data		      #
#################################################

mix1<-read.table('mix1.txt', header=FALSE, 
         na.strings="NA", dec=",",  strip.white=TRUE)

agegr<-as.numeric(as.vector(mix1$V3))
Yi<-as.numeric(as.vector(mix1$V4))
age1<-as.numeric(as.vector(mix1$V2))
length(unique(agegr))
length(unique(age1))
Nage<-49
Nsub<-2752
mu1<- 6.323
mu2<- 2.319


### FIGURE 11.6
windows(record=TRUE, width=6.65, height=3.5)
par(mfrow=c(1,2),lwd=2,las=1,cex.axis=0.8,cex.lab=0.8,mgp=c(2, 0.45, 0),
mar=c(3.2, 2.8, 3.5, 1.5))

plot(age1,Yi,xlab="age",ylab="log(antibody)",cex=0.7,lwd=1,col="darkgrey")
lines(c(0,40),c(mu1,mu1),lwd=2)
lines(c(0,40),c(mu2,mu2),lwd=2)

hist(Yi,nclass=50,col=0,probability=T,xlab="log(antibody)",ylim=c(0,0.4),main=" ")
lines(c(mu1,mu1),c(0,0.35),lwd=2)
lines(c(mu2,mu2),c(0,0.35),lwd=2)
arrows(mu1,0.34,mu2,0.34,length=0.1)
arrows(mu2,0.34,mu1,0.34,length=0.1)
text(mu2,0.4,expression(bar(mu)[1]))
text(mu1,0.4,expression(bar(mu)[2]))
text((mu1+mu2)/2,0.315,expression(bar(delta)))


### FIGURE 11.7
# Importing results from Winbugs 1.4
pii<-read.table('pii.txt', header=FALSE,na.strings="NA", dec=",",  strip.white=TRUE)
foii<-read.table('foii.txt', header=FALSE,na.strings="NA", dec=",",  strip.white=TRUE)
classify<-read.table('clasify.txt',header=FALSE,na.strings="NA", dec=",",  strip.white=TRUE)

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(5.1,3.5,4.1,4))

zpost<-tapply(as.numeric(as.vector(classify$V6)),as.factor(age1),mean)
plot(unique(age1),zpost,xlab="age",ylab="seroprevalence",cex=0.8,ylim=c(0,1),lwd=2)
lines(unique(age1),1-as.numeric(as.vector(pii$V6)),lty=1)
lines(unique(age1),1-as.numeric(as.vector(pii$V5)),lty=2)
lines(unique(age1),1-as.numeric(as.vector(pii$V7)),lty=2)

lines(unique(age1),as.numeric(as.vector(foii$V2))/2,type="l",ylim=c(0,0.45),
		xlab="age",ylab="force of infection")
lines(unique(age1),as.numeric(as.vector(foii$V5))/2,lty=2)
lines(unique(age1),as.numeric(as.vector(foii$V7))/2,lty=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4),label=c(0.0,0.1,0.2,0.3,0.4)/2)
mtext(side=4,las=3,"force-of-infection",line=2)


########################################################
## Section 11.5: Modeling the Force of Infection       #
##      	directly from antibody titers using        #
##      	hierarchical mixture models                #
##      							       #
##  11.5.4 Determining the current infection status    #
########################################################


### FIGURE 11.8
# Importing results from Winbugs 1.4
pii7<-read.table('pii7.txt', header=FALSE, 
                           na.strings="NA", dec=",",  strip.white=TRUE)
agecat<-unique(age1)[7]
agecat
age2<-age1[age1 == agecat]
length(age2)
zpost2<-as.numeric(as.vector(classify$V6))[age1 == agecat]
Yi2<-Yi[age1 == agecat]

dev.off()
windows(record=TRUE, width=6.65, height=6.65)
par(mfrow=c(2,2),lwd=2,las=1,cex.axis=1.1,cex.lab=1,mgp=c(2, 0.45, 0),
mar=c(3.2, 2.8, 3.5, 1.5))

hist(Yi2,nclass=10,col=0,xlab="log(antibody)",main=" ")

plot(Yi2,zpost2,xlab="log(antibody)",ylab=expression(paste("posterior median for ","Y"[i])),yaxt="n")

pii1<-sum(zpost2)/length(zpost2)
barplot(c(pii1,1-pii1),col=0,names=c("Sero+","Sero-"))
text(0.7,pii1-0.1,paste(round(pii1,digits=4)*100,"%"))
text(1.90,1-pii1-0.1,paste(round(1-pii1,digits=4)*100,"%"))

hist(1-as.numeric(as.vector(pii7$V2)),probability = T,nclass=30,col=0,xlab=expression(pi(5.3)),main=" ")
xxx<-1-as.numeric(as.vector(pii7$V2))
dx<-density(xxx)
lines(dx$x,dx$y)

